/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.SQLServerAsyncDBExecThread;

public class SQLServerExportDBExecThread
extends SQLServerAsyncDBExecThread {
    private static final Log LOG = LogFactory.getLog(SQLServerExportDBExecThread.class);
    protected static final String SQLSTATE_CODE_CONSTRAINT_VIOLATION = "23000";
    private boolean failedCommit = false;

    @Override
    protected PreparedStatement getPreparedStatement(List<SqoopRecord> records) throws SQLException {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        stmt = conn.prepareStatement(this.getInsertStatement(records.size()));
        for (SqoopRecord record : records) {
            record.write(stmt, 0);
            stmt.addBatch();
        }
        return stmt;
    }

    @Override
    protected void executeStatement(PreparedStatement stmt, List<SqoopRecord> records) throws SQLException {
        Connection conn = this.getConnection();
        try {
            stmt.executeBatch();
        }
        catch (SQLException execSqlEx) {
            LOG.warn((Object)("Error executing statement: " + execSqlEx));
            if (this.failedCommit && this.canIgnoreForFailedCommit(execSqlEx.getSQLState())) {
                LOG.info((Object)"Ignoring error after failed commit");
            }
            throw execSqlEx;
        }
        try {
            conn.commit();
            this.failedCommit = false;
        }
        catch (SQLException commitSqlEx) {
            LOG.warn((Object)("Error while committing transactions: " + commitSqlEx));
            this.failedCommit = true;
            throw commitSqlEx;
        }
    }

    protected String getInsertStatement(int numRows) {
        int numSlots;
        StringBuilder sb = new StringBuilder();
        if (this.getConf().getBoolean("org.apache.sqoop.manager.sqlserver.table.identity", false)) {
            LOG.info((Object)"Enabling identity inserts");
            sb.append("SET IDENTITY_INSERT ").append(this.tableName).append(" ON ");
        }
        sb.append("INSERT INTO " + this.tableName + " ");
        String tableHints = this.getConf().get("org.apache.sqoop.manager.sqlserver.table.hints");
        if (tableHints != null) {
            LOG.info((Object)("Using table hints: " + tableHints));
            sb.append(" WITH (").append(tableHints).append(") ");
        }
        if (this.columnNames != null) {
            numSlots = this.columnNames.length;
            sb.append("(");
            boolean first = true;
            for (String col : this.columnNames) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(col);
                first = false;
            }
            sb.append(") ");
        } else {
            numSlots = this.columnCount;
        }
        sb.append("VALUES ");
        sb.append("(");
        for (int i = 0; i < numSlots; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean canIgnoreForFailedCommit(String sqlState) {
        return sqlState == SQLSTATE_CODE_CONSTRAINT_VIOLATION;
    }
}

