/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetRecordReader;
import org.apache.sqoop.util.MainframeFTPClientUtils;

public class MainframeDatasetFTPRecordReader<T extends SqoopRecord>
extends MainframeDatasetRecordReader<T> {
    private FTPClient ftp = null;
    private BufferedReader datasetReader = null;
    private static final Log LOG = LogFactory.getLog((String)MainframeDatasetFTPRecordReader.class.getName());

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        super.initialize(inputSplit, taskAttemptContext);
        Configuration conf = this.getConfiguration();
        this.ftp = MainframeFTPClientUtils.getFTPConnection(conf);
        if (this.ftp != null) {
            String dsName = conf.get("mapreduce.mainframe.input.dataset.name");
            this.ftp.changeWorkingDirectory("'" + dsName + "'");
        }
    }

    public void close() throws IOException {
        if (this.datasetReader != null) {
            this.datasetReader.close();
        }
        if (this.ftp != null) {
            MainframeFTPClientUtils.closeFTPConnection(this.ftp);
        }
    }

    @Override
    protected boolean getNextRecord(T sqoopRecord) throws IOException {
        String line = null;
        try {
            do {
                if (this.datasetReader == null) {
                    String dsName = this.getNextDataset();
                    if (dsName == null) break;
                    this.datasetReader = new BufferedReader(new InputStreamReader(this.ftp.retrieveFileStream(dsName)));
                }
                if ((line = this.datasetReader.readLine()) != null) continue;
                this.datasetReader.close();
                this.datasetReader = null;
                if (!this.ftp.completePendingCommand()) {
                    throw new IOException("Failed to complete ftp command.");
                }
                LOG.info((Object)"Data transfer completed.");
            } while (line == null);
        }
        catch (IOException ioe) {
            throw new IOException("IOException during data transfer: " + ioe.toString());
        }
        if (line != null) {
            this.convertToSqoopRecord(line, (SqoopRecord)sqoopRecord);
            return true;
        }
        return false;
    }

    private void convertToSqoopRecord(String line, SqoopRecord sqoopRecord) {
        String fieldName = sqoopRecord.getFieldMap().entrySet().iterator().next().getKey();
        sqoopRecord.setField(fieldName, line);
    }
}

