/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;

public class MainframeDatasetImportMapper
extends AutoProgressMapper<LongWritable, SqoopRecord, Text, NullWritable> {
    private static final Log LOG = LogFactory.getLog((String)MainframeDatasetImportMapper.class.getName());
    private MainframeDatasetInputSplit inputSplit;
    private MultipleOutputs<Text, NullWritable> mos;
    private long numberOfRecords;
    private Text outkey;

    public void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        String dataset = this.inputSplit.getCurrentDataset();
        this.outkey.set(val.toString());
        ++this.numberOfRecords;
        this.mos.write((Object)this.outkey, (Object)NullWritable.get(), dataset);
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.inputSplit = (MainframeDatasetInputSplit)context.getInputSplit();
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        this.numberOfRecords = 0L;
        this.outkey = new Text();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        this.mos.close();
        context.getCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_OUTPUT_RECORDS").increment(this.numberOfRecords);
    }
}

