/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.postgresql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.sqoop.mapreduce.AutoProgressReducer;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.util.LoggingUtils;

public class PGBulkloadExportReducer
extends AutoProgressReducer<LongWritable, Text, NullWritable, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)PGBulkloadExportReducer.class.getName());
    private Configuration conf;
    private DBConfiguration dbConf;
    private Connection conn;
    private String tableName;

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.dbConf = new DBConfiguration(this.conf);
        this.tableName = this.dbConf.getOutputTableName();
        try {
            this.conn = this.dbConf.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unable to load JDBC driver class", (Throwable)ex);
            throw new IOException(ex);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to connect to database", ex);
            throw new IOException(ex);
        }
    }

    public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            for (Text value : values) {
                int inserted = stmt.executeUpdate("INSERT INTO " + this.tableName + " ( SELECT * FROM " + value + " )");
                stmt.executeUpdate("DROP TABLE " + value);
            }
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to execute create query.", ex);
            throw new IOException(ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close statement", ex);
                }
            }
        }
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        try {
            this.conn.commit();
            this.conn.close();
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to load JDBC driver class", ex);
            throw new IOException(ex);
        }
    }
}

