import zlib
import redis


class GetRedisData(object):

    def __init__(self, asin='', batch_size=100000):
        self.asin = asin
        self.batch_size = batch_size
        # 连接到Redis服务器
        self.redis_db = {
            "us": 0,
            "uk": 1,
            "de": 2,
            "es": 3,
            "fr": 4,
            "it": 5,
        }
        self.site_name = 'us'
        self.client = redis.Redis(host='192.168.10.224', port=6379, db=self.redis_db[self.site_name], password='yswg2023')

    @staticmethod
    def udf_cal_crc32(asin, key_size):
        # crc32算法 + 取余

        # 获取asin字符串的字节表示形式
        bytes_str = bytes(asin, 'utf-8')
        # 使用zlib计算CRC-32校验和
        checksum = zlib.crc32(bytes_str)
        # 获取32位的二进制补码
        checksum_signed = (checksum & 0xFFFFFFFF) - (1 << 32) if checksum & (1 << 31) else checksum

        def java_mod(x, y):
            # return x % y if x * y > 0 else x % y - y  # 区分正负值
            return abs(x) % y  # 不区分正负值

        # 取余
        result = java_mod(checksum_signed, key_size)
        print(f"result:{result}")
        return result

    @staticmethod
    def udf_cal_bkdr(asin):
        # BKDR哈希算法
        hash = 0
        for c in asin:
            hash = (hash * 33 + ord(c)) % 65535  # 对哈希值取模65535，以避免溢出
        print(f"hash:{hash}")
        return hash

    def get_redis_data(self):

        # 连接到 Redis
        # client = redis.Redis(host='localhost', port=6379, db=0)

        # 外层键
        outer_key = self.udf_cal_crc32(asin=self.asin, key_size=self.batch_size)
        # 内层键
        inner_key = self.udf_cal_bkdr(asin=self.asin)

        # # 外层键
        # inner_key = self.udf_cal_crc32(asin=self.asin, key_size=self.batch_size)
        # # 内层键
        # outer_key = self.udf_cal_bkdr(asin=self.asin)

        # 从 Redis 哈希表获取数据
        value = self.client.hget(outer_key, inner_key)

        if value:
            print(value.decode("utf-8"))
        else:
            print("Key not found")

    def run(self):
        self.udf_cal_crc32(asin=self.asin, key_size=self.batch_size)
        self.udf_cal_bkdr(asin=self.asin)


if __name__ == '__main__':
    # handle_obj = KafkaAsinDetailHistory(asin='B0C7BZL9C3')
    # handle_obj = KafkaAsinDetailHistory(asin='B0C6DM2V9X')
    # handle_obj = KafkaAsinDetailHistory(asin='B0BV7CBQW3')
    handle_obj = GetRedisData(asin='B08KR79NBR')
    # handle_obj = GetRedisData(asin='B0062TMTMK')
    # handle_obj.run()
    handle_obj.get_redis_data()