import os
import sys
import time

sys.path.append(os.path.dirname(sys.path[0]))
from utils.redis_utils import RedisUtils
from utils.ssh_util import SSHUtil

from utils.common_util import CommonUtil

"""
定时任务执行
"""


def timer():
    import threading
    # 设置定时器，每5分钟执行一次
    threading.Timer(300, timer).start()
    client = RedisUtils.getClient()
    list_key = "asin_img_path:list"
    if client.exists(list_key):
        llen = int(client.llen(list_key))
        if llen > 100000:
            return

    print("调度执行中！")
    sh = rf"""
        /opt/module/spark/bin/spark-submit  \
        --master yarn \
        --driver-memory 2g \
        --executor-memory 10g \
        --executor-cores 2 \
        --num-executors 5 \
        --queue spark \
        {CommonUtil.__desploy_home__}/script/asin_img_parse_sender.py
        """
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
    pass


if __name__ == '__main__':
    # 启动定时器
    timer()
