/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopUtilities;

public class OraOopLogMessage {
    private OraOopConstants.Logging.Level level;
    private String message;

    public OraOopLogMessage(OraOopConstants.Logging.Level level, String message) {
        this.level = level;
        this.message = message;
    }

    public void log(OraOopLog log) {
        switch (this.level) {
            case TRACE: {
                log.trace(this.message);
                break;
            }
            case DEBUG: {
                log.debug(this.message);
                break;
            }
            case INFO: {
                log.info(this.message);
                break;
            }
            case WARN: {
                log.warn(this.message);
                break;
            }
            case ERROR: {
                log.error(this.message);
                break;
            }
            case FATAL: {
                log.fatal(this.message);
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s needs to be updated to cater for the message level \"%s\".", OraOopUtilities.getCurrentMethodName(), this.level.toString()));
            }
        }
    }
}

