/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ImportException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.sqoop.mapreduce.HBaseBulkImportMapper;
import org.apache.sqoop.mapreduce.HBaseImportJob;

public class HBaseBulkImportJob
extends HBaseImportJob {
    public static final Log LOG = LogFactory.getLog((String)HBaseBulkImportJob.class.getName());

    public HBaseBulkImportJob(SqoopOptions opts, ImportJobContext importContext) {
        super(opts, importContext);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(Put.class);
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return HBaseBulkImportMapper.class;
    }

    @Override
    protected void jobSetup(Job job) throws IOException, ImportException {
        super.jobSetup(job);
        if (this.getContext().getDestination() == null) {
            throw new ImportException("Can't run HBaseBulkImportJob without a valid destination directory.");
        }
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{Preconditions.class});
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getContext().getDestination());
        HTable hTable = new HTable(job.getConfiguration(), this.options.getHBaseTable());
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)hTable);
    }

    @Override
    protected void completeImport(Job job) throws IOException, ImportException {
        super.completeImport(job);
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        Path bulkLoadDir = this.getContext().getDestination();
        this.setPermission(fileSystem, fileSystem.getFileStatus(bulkLoadDir), FsPermission.createImmutable((short)511));
        HTable hTable = new HTable(job.getConfiguration(), this.options.getHBaseTable());
        try {
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(job.getConfiguration());
            loader.doBulkLoad(bulkLoadDir, hTable);
        }
        catch (Exception e) {
            String errorMessage = String.format("Unrecoverable error while performing the bulk load of files in [%s]", bulkLoadDir.toString());
            throw new ImportException(errorMessage, e);
        }
    }

    @Override
    protected void jobTeardown(Job job) throws IOException, ImportException {
        super.jobTeardown(job);
        FileSystem fileSystem = FileSystem.get((Configuration)job.getConfiguration());
        fileSystem.delete(this.getContext().getDestination(), true);
    }

    private void setPermission(FileSystem fs, FileStatus fileStatus, FsPermission permission) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus file : fs.listStatus(fileStatus.getPath())) {
                this.setPermission(fs, file, permission);
            }
        }
        fs.setPermission(fileStatus.getPath(), permission);
    }
}

