import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.db_util import DBUtil

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)

    db_type = "postgresql_cluster"
    print("导出到postgresql_cluster中")

    export_tb = f"{site_name}_st_key"
    engine = DBUtil.get_db_engine(db_type, site_name)

    with engine.connect() as connection:
        sql = f""" select * from {export_tb} where site_name ='{site_name}' and date_info ='{date_info}' limit 1;"""
        print("================================执行sql================================")
        print(sql)
        size = len(list(connection.execute(sql)))
        if size != 0:
            print(f"当天数据{date_info}已经导出，请勿重复导出！")
            sys.exit(0)

    # # 导出表名
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwd_day_asin",
        export_tb=export_tb,
        col=[
            "asin",
            "queue_name",
            "site_name",
            "date_info",
        ],
        partition_dict={
            "site_name": site_name,
            "date_info": date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()
    #  导出完毕后删除之前日的数据
    with engine.connect() as connection:
        sql = f""" delete from {export_tb} where site_name ='{site_name}' and date_info < '{date_info}' """
        print("================================删除之前数据中================================")
        connection.execute(sql)
    print("success")