import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.db_util import DBUtil
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    #  获取最后一个参数
    test_flag = CommonUtil.get_sys_arg(len(sys.argv) - 1, None)

    print(f"执行参数为{sys.argv}")

    if test_flag == 'test':
        db_type = 'postgresql_test'
        print("导出到测试库中")
    else:
        db_type = "postgresql"
        print("导出到PG库中")

    export_tb = f"{site_name}_aba_sv_last_365"

    engine = DBUtil.get_db_engine(db_type, site_name)
    with engine.connect() as connection:
        sql = f"""
                   truncate table us_aba_sv_last_365
                """
        print("================================执行sql================================")
        print(sql)
        connection.execute(sql)

    # 导出表名
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_st_sv_last365",
        export_tb=export_tb,
        col=[
            "search_term_id",
            "search_term",
            "total_search_volume",
            "sv_rank",
            "date_info",
        ],
        partition_dict={
            "site_name": site_name,
            "date_info": date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()

    print("success")
