import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.db_util import DBUtil
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)

    db_type = "postgresql_cluster"
    export_tb = "us_bulk_market"

    # 获取数据库连接
    engine = DBUtil.get_db_engine(db_type, site_name)

    # 导出agg表
    sh_report = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="dwt_bulk_market_pg",
        export_tb=export_tb,
        col=[
            "search_term",
            "search_volume",
            "search_volume_avg3_month",
            "search_volume_avg12_month",
            "st_asin_count",
            "st_asin_page1_review_count",
            "st_depth",
            "st_sponsored_ads",
            "st_appearance",
            "asin_count",
            "self_asin_count",
            "proportion"
        ],
        partition_dict={
            "site_name": site_name,
            "date_type": date_type,
            "date_info": date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh_report, ignore_err=False)

    client.close()
    engine.dispose()

    print("success")
