import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil, DateTypes
from utils.db_util import DBUtil

if __name__ == '__main__':
    # 获取入参
    site_name = CommonUtil.get_sys_arg(1, None)
    asin_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)


    #  获取最后一个参数
    test_flag = CommonUtil.get_sys_arg(len(sys.argv) - 1, None)

    print(f"执行参数为{sys.argv}")

    print(test_flag)

    if test_flag == 'test':
        db_type = 'postgresql_test'
        print("导出到测试库中")
    else:
        CommonUtil.judge_is_work_hours(site_name=site_name, date_info=date_info, principal='chenyuanjie',
                                       priority=4, export_tools_type=1, belonging_to_process='自然asin汇总')
        db_type = "postgresql_cluster"
        print("导出到PG集群库中")

    # 获取数据库连接
    engine = DBUtil.get_db_engine(db_type, site_name)

    if asin_type == 'all':
        asin_type_array = [
            'b01_b06',
            'b070_b079',
            'b07a_b07z',
            'b080_b089',
            'b08a_b08z',
            'b090_b099',
            'b09a_b09n',
            'b09o_b09z',
            'b0b0_b0b9',
            'b0ba_b0bg',
            'b0bh_b0bk',
            'b0bl_b0bn',
            'b0bo_b0br',
            'b0bs_b0bv',
            'b0bw_b0bz',
            'other'
        ]
    else:
        asin_type_array = asin_type.split(",")

    for asin_type in asin_type_array:
        # 导出表
        export_tb = f"{site_name}_hive_asin_old_total_{asin_type}"
        export_tb_copy = f"{site_name}_hive_asin_old_total_{asin_type}_copy1"
        export_tb_tmp = f"{site_name}_hive_asin_old_total_{asin_type}_tmp"
        # 导出字段
        export_cols = [
            "asin",
            "times_list",
            "ao_list",
            "zr_count_list",
            "sp_count_list",
            "sb_count_list",
            "orders_list",
            "bsr_orders_list",
            "bsr_orders_sale_list"
        ]
        engine = DBUtil.get_db_engine(db_type, site_name)

        before_export_sql = f"""
            truncate table {export_tb_copy}
        """
        DBUtil.engine_exec_sql(engine, sql=before_export_sql)
        # 将asin_type转换成大写，对应hdfs的路径
        asin_type_upper = str(asin_type).upper()

        # 导出执行sqoop的sh编写
        sh = CommonUtil.build_export_sh(
            site_name=site_name,
            db_type=db_type,
            hive_tb="dwt_zr_asin_info",
            export_tb=export_tb_copy,
            col=export_cols,
            partition_dict={
                "site_name": site_name,
                "asin_type": asin_type_upper
            }
        )

        client = SSHUtil.get_ssh_client()
        SSHUtil.exec_command_async(client, sh, ignore_err=False)
        client.close()

        after_export_sql = f"""
            ALTER TABLE {export_tb_copy} RENAME TO {export_tb_tmp};
            ALTER TABLE {export_tb} RENAME TO {export_tb_copy};
            ALTER TABLE {export_tb_tmp} RENAME TO {export_tb};
        """
        DBUtil.engine_exec_sql(engine, sql=after_export_sql)

