/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldMapProcessor;
import com.cloudera.sqoop.lib.FieldMappable;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.ProcessingException;
import com.cloudera.sqoop.lib.RecordParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.sqoop.mapreduce.DBWritable;

public abstract class SqoopRecord
implements Cloneable,
DBWritable,
FieldMappable,
Writable {
    public abstract void parse(CharSequence var1) throws RecordParser.ParseError;

    public abstract void parse(Text var1) throws RecordParser.ParseError;

    public abstract void parse(byte[] var1) throws RecordParser.ParseError;

    public abstract void parse(char[] var1) throws RecordParser.ParseError;

    public abstract void parse(ByteBuffer var1) throws RecordParser.ParseError;

    public abstract void parse(CharBuffer var1) throws RecordParser.ParseError;

    public abstract void loadLargeObjects(LargeObjectLoader var1) throws SQLException, IOException, InterruptedException;

    public abstract int write(PreparedStatement var1, int var2) throws SQLException;

    public abstract String toString(DelimiterSet var1);

    public String toString(boolean useRecordDelim) {
        if (useRecordDelim) {
            return this.toString();
        }
        throw new RuntimeException("toString(useRecordDelim=false) requires a newer SqoopRecord. Please regenerate your record class to use this function.");
    }

    public String toString(DelimiterSet delimiters, boolean useRecordDelim) {
        if (useRecordDelim) {
            return this.toString(delimiters);
        }
        throw new RuntimeException("toString(delimiters, useRecordDelim=false) requires a newer SqoopRecord. Please regenerate your record class to use this function.");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract int getClassFormatVersion();

    public void delegate(FieldMapProcessor processor) throws IOException, ProcessingException {
        processor.accept(this);
    }

    @Override
    public Map<String, Object> getFieldMap() {
        throw new RuntimeException("Got null field map from record. Regenerate your record class.");
    }

    public void setField(String fieldName, Object fieldVal) {
        throw new RuntimeException("This SqoopRecord does not support setField(). Regenerate your record class.");
    }
}

