import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))

from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil
from utils.db_util import DBUtil

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)

    CommonUtil.judge_is_work_hours(
        site_name=site_name,
        principal='chenyuanjie', priority=1, export_tools_type=1, belonging_to_process='更新搜索词key'
    )

    db_type = 'postgresql_cluster'
    engine = DBUtil.get_db_engine(db_type, site_name)
    export_cols = [
        'st_key',
        'search_term'
    ]

    export_tb = f"{site_name}_st_key_copy"
    export_tb_target = f"{site_name}_st_key"

    # 建表
    sql = f"""
        DROP TABLE IF EXISTS {export_tb};
        CREATE TABLE IF NOT EXISTS {export_tb} (
            st_key int8 NOT NULL,
            search_term varchar(500) NOT NULL,
            keyword_tsv tsvector
        );
    """
    DBUtil.engine_exec_sql(engine, sql)

    # 导出数据
    partition_dict = {
        "site_name": site_name
    }
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb="ods_st_key",
        export_tb=export_tb,
        col=export_cols,
        partition_dict=partition_dict
    )
    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()

    # 创建索引，交换表名
    sql = f"""
    update {export_tb} set keyword_tsv = to_tsvector('english_amazonword', search_term);
    """
    DBUtil.engine_exec_sql(engine, sql)
    DBUtil.exchange_tb(
        engine=engine,
        source_tb_name=export_tb,
        target_tb_name=export_tb_target,
        cp_index_flag=True
    )
    print("success！")
