#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# author: ffman
# usage: 同步各个站点的店铺表的asin详情表
# params: 参数1:site_name;
# version: 2.0
# create_date:2022-3-15
# update_date:2022-11-02




# 根据site_name来判断数据库名称
if [ $1 == all ];
then
        site_name_array=(us uk de es fr it)
else
        site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"


for site_name in ${site_name_array[*]}
    do
                echo 1. 当前连接的mysql数据库站点: ${site_name}
                if [ $site_name == us ];
                then
                        db=selection
                else
                        db=selection_$site_name
                fi
                echo "db: ${db}"
                echo 2. 先删除已经存在的分区
                hive_table=ods_seller_account_feedback
                hdfs_path="/home/big_data_selection/ods/${hive_table}/site_name=${site_name}"
                hdfs dfs -rm -r ${hdfs_path}/*
                echo 3. 导入数据
                mysql_table=${site_name}_seller_account_feedback
		cols="id,account_id,site_name as country_name,count_30_day,count_1_year,count_lifetime,created_at,updated_at"
		query="select ${cols} from ${mysql_table} where 1=1 and \$CONDITIONS"
                import_data
     done
