import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.db_util import DBUtil, DbTypes
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil


def export_postgresql():
    pass


def export_postgresql_cluster():
    site_name = CommonUtil.get_sys_arg(1, None)
    date_info = CommonUtil.get_sys_arg(2, None)
    tb_type = CommonUtil.get_sys_arg(3, None)

    # 导出detail到集群
    CommonUtil.judge_is_work_hours(
        site_name=site_name,
        date_type="day",
        date_info=date_info,
        principal='wujicang',
        priority=1,
        export_tools_type=1
    )

    db_type = DbTypes.postgresql_cluster.name
    print(f"导出到{db_type}中")

    d_month_now = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y_%m", )
    rel_date_info = CommonUtil.reformat_date(date_info, "%Y-%m-%d", "%Y-%m", )
    next_month = CommonUtil.get_month_offset(rel_date_info, 1)
    # 导出表
    export_master_tb = f"{site_name}_{tb_type}_asin_detail"
    export_tb = f"{export_master_tb}_{d_month_now}"
    export_tb_copy = f"{export_tb}_copy"

    sql = f"""drop table if exists {export_tb_copy}"""
    DBUtil.exec_sql(db_type=db_type, site_name=site_name, sql=sql, dispose_flag=True)


    sql = f"""create table {export_tb_copy} (  like {export_master_tb} including defaults including constraints );"""
    DBUtil.exec_sql(db_type=db_type, site_name=site_name, sql=sql, dispose_flag=True)

    # 导出表名
    sh = CommonUtil.build_export_sh(
        site_name=site_name,
        db_type=db_type,
        hive_tb=f"dwt_{tb_type}_asin_detail",
        export_tb=export_tb_copy,
        col=[
            "asin",
            "title",
            "img_url",
            "ao_val",
            "rating",
            "total_comments",
            "bsr_orders",
            "bsr_orders_change",
            "price",
            "weight",
            "launch_time",
            "date_info",
            "brand_name",
            "buy_box_seller_type",
            "account_name",
            "volume",
            "img_type",
            "last_update_time",
            "asin_type",
            "asin_air_freight_gross_margin",
            "asin_ocean_freight_gross_margin",
            "asin_unlaunch_time",
            "seller_id",
            "seller_country_name",
            "category_first_id",
            "first_category_rank",
            "first_category_rank_date",
            "package_quantity",
            "asin_launch_time_type",
            "seller_country_type",
            "asin_bought_month",
        ],
        partition_dict={
            "site_name": site_name,
            "date_info": rel_date_info
        }
    )

    client = SSHUtil.get_ssh_client()
    SSHUtil.exec_command_async(client, sh, ignore_err=False)
    client.close()

    # 导出表
    engine = DBUtil.get_db_engine(db_type, site_name)
    DBUtil.exchange_pg_part_distributed_tb(
        engine=engine,
        source_tb_name=export_tb_copy,
        part_master_tb=export_master_tb,
        part_target_tb=export_tb,
        part_val={
            "from": [rel_date_info],
            "to": [next_month]
        },
        drop_old=True
    )
    engine.dispose()
    print("success")


pass

if __name__ == '__main__':
    export_postgresql_cluster()
