import requests
from requests.auth import HTTPBasicAuth
import base64


def stream_load(data):
    database, table = 'adv', 'sp_customer_search_target_report_copy'
    username, password = 'root', ''
    url = 'http://192.168.10.218:18030/api/%s/%s/_stream_load' % (database, table)
    headers = {
        'Content-Type': 'text/plain; charset=UTF-8',
        'format': 'csv',
        "column_separator": ',',
        'Expect': '100-continue',
        'Authorization': 'Basic ' + base64.b64encode((username + ':' + password).encode('utf-8')).decode('ascii')
    }
    auth = HTTPBasicAuth(username, password)
    session = requests.sessions.Session()
    session.should_strip_auth = lambda old_url, new_url: False  # Don't strip auth

    resp = session.request(
        'PUT', url=url,
        data=data,
        headers=headers, auth=auth
    )

    print(resp.status_code, resp.reason)
    print(resp.text)

