#! /bin/env bash
source /mnt/run_shell/sqoop_shell/templates.sh

# 根据site_name来判断数据库名称
if [ $1 == all ];
then
    site_name_array=(us uk de es fr it)
else
    site_name_array=($1)
fi
echo "site_name_array: ${site_name_array}"

date_type=$2
date_info=$3
d1=`echo $date_info | cut -d \- -f 1`
d2=`echo $date_info | cut -d \- -f 2`

for site_name in ${site_name_array[*]}
	do
		echo 1. 当前连接的数据库站点: ${site_name}
		if [ ${site_name} == us ];
		then
			db=selection
		else
			db=selection_${site_name}
		fi
		echo "db: ${db}"

		# 导入数据
		import_table=${site_name}_aba_last_top_asin_${d1}_${d2}
		truncate_table=${site_name}_aba_last_top_asin_${d1}_${d2}
		hive_table=dwt_st_top_asin_info
		db_type=postgresql
		hdfs_path=/home/big_data_selection/dwt/${hive_table}/site_name=${site_name}/date_type=$date_type/date_info=$date_info
		p_keys="site_name,date_type,date_info"
		p_values="$site_name,$date_type,$date_info"
		cols="site_name,search_term_id,search_term,asin,date_info,data_type,zr_rank,created_time,updated_time"
		truncate_data
		export_data
    done

