package cn.kk.spring_simple_operation;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.converts.SelfMySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.querys.MySqlQuery;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.baomidou.mybatisplus.generator.keywords.MySqlKeyWordsHandler;

import java.util.Collections;

/**
 * @author guokunkun
 * @date 2023/4/24
 */
public class CodeGenerator {

    //private static final String DB_URL = "jdbc:mysql://120.77.232.73:3306/java_visual?useUnicode=true&characterEncoding=utf8&useSSL=true";
    //private static final String DB_USERNAME = "yswg_it_java";
    //private static final String DB_PASSWORD = "Yswg@inv-java241011427";

    private static final String DB_URL = "jdbc:mysql://mydb.com:3306/visual_0102?useUnicode=true&characterEncoding=utf8&useSSL=true";
    private static final String DB_USERNAME = "root";
    private static final String DB_PASSWORD = "root";

    public static final String DIR = System.getProperty("user.dir");

    private static DataSourceConfig.Builder getDataConfigBuilder() {
        return new DataSourceConfig.Builder(DB_URL, DB_USERNAME, DB_PASSWORD).
                dbQuery(new MySqlQuery()).
                keyWordsHandler(new MySqlKeyWordsHandler()).
                schema("Mybatis-Plus").
                typeConvert(new SelfMySqlTypeConvert());
    }

    public static void generate() {
        FastAutoGenerator.create(getDataConfigBuilder())
                .globalConfig(builder -> {
                    builder.author("guokunkun") // 设置作者
                            .enableSwagger() // 开启 swagger 模式
                            .fileOverride() // 覆盖已经存在的文件
                            .outputDir(DIR + "/src/main/java") // 指定输出目录
                            .disableOpenDir(); //禁止打开输出目录
                })
                .packageConfig(builder -> {
                    builder.parent("cn.kk") // 设置父包名
                            .moduleName("spring_simple_operation") // 设置父包模块名
                            .pathInfo(Collections.singletonMap(OutputFile.mapperXml, DIR + "/src/main/resources/mapper")); // 设置mapperXml生成路径
                })
                // 策略配置
                .strategyConfig(builder -> {
                    builder
                            // 设置需要生成的表名
                            .addInclude("brand_record_tool")

                            //entity策略配置
                            .entityBuilder()
                            .enableLombok()
                            .logicDeleteColumnName("is_delete") //设置逻辑删除字段名
                            .enableTableFieldAnnotation() // 开启字段注解：@TableField("return_sample_way")
                            .enableChainModel() //开启链式模型

                            // mapper 配置
                            .mapperBuilder()
                            .superClass(BaseMapper.class) // 设置父类
                            .formatMapperFileName("%sMapper") // 格式化mapper文件名称
                            .enableMapperAnnotation() //开启 @Mapper注解
                            .formatXmlFileName("%sMapper") // 格式化Xml文件名称

                            // service 配置
                            .serviceBuilder()
                            .formatServiceFileName("%sService") //格式化service名称：UserService
                            .formatServiceImplFileName("%sServiceImpl") //

                            // controller 配置
                            .controllerBuilder()
                            .formatFileName("%sController") // 格式化controller名称
                            .enableRestStyle(); // 开启生成 @RestController 控制器
                })
                .templateEngine(new FreemarkerTemplateEngine()) // 使用Freemarker引擎模板，默认的是Velocity引擎模板
                .execute();
    }

    public static void main(String[] args) {
        generate();
    }
}
