package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author guokunkun
 * @since 2024-12-25
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("photo_progress_person")
@ApiModel(value = "PhotoProgressPerson对象", description = "")
public class PhotoProgressPerson implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id(photo_progress主键id)")
    @TableId("id")
    private Long id;

    @ApiModelProperty("审核产品id")
    @TableField("product_id")
    private Integer productId;

    @ApiModelProperty("创建时间")
    @TableField("create_at")
    private Integer createAt;

    @ApiModelProperty("平面设计1名字")
    @TableField("plane_design_1_name")
    private String planeDesign1Name;

    @ApiModelProperty("平面设计1编号")
    @TableField("plane_design_1_num")
    private String planeDesign1Num;

    @ApiModelProperty("平面设计1完成时间")
    @TableField("plane_design_1_time")
    private Integer planeDesign1Time;

    @ApiModelProperty("平面设计2名字")
    @TableField("plane_design_2_name")
    private String planeDesign2Name;

    @ApiModelProperty("平面设计2编号")
    @TableField("plane_design_2_num")
    private String planeDesign2Num;

    @ApiModelProperty("平面设计2完成时间")
    @TableField("plane_design_2_time")
    private Integer planeDesign2Time;

    @ApiModelProperty("摄影完成状态，0- 未完成，1-进行中，2-完成，默认未完成")
    @TableField("photo_progress")
    private Integer photoProgress;

    @ApiModelProperty("摄影人员名字")
    @TableField("photographer_name")
    private String photographerName;

    @ApiModelProperty("摄影人员编号")
    @TableField("photographer_num")
    private String photographerNum;

    @ApiModelProperty("摄影完成时间")
    @TableField("photo_finish_time")
    private Integer photoFinishTime;

    @ApiModelProperty("平面设计1完成状态，0- 未完成，1-进行中，2-完成，默认未完成")
    @TableField("plane_design_1_progress")
    private Integer planeDesign1Progress;

    @ApiModelProperty("平面设计2完成状态，0- 未完成，1-进行中，2-完成，默认未完成")
    @TableField("plane_design_2_progress")
    private Integer planeDesign2Progress;

    @ApiModelProperty("交接前最初的平面设计1名字")
    @TableField("original_plane_design_1_name")
    private String originalPlaneDesign1Name;

    @ApiModelProperty("交接前最初的平面设计1编号")
    @TableField("original_plane_design_1_num")
    private String originalPlaneDesign1Num;

    @ApiModelProperty("交接前最初的平面设计2名字")
    @TableField("original_plane_design_2_name")
    private String originalPlaneDesign2Name;

    @ApiModelProperty("交接前最初的平面设计1编号")
    @TableField("original_plane_design_2_num")
    private String originalPlaneDesign2Num;

    @ApiModelProperty("简易视频摄影名字")
    @TableField("simple_video_photographer_name")
    private String simpleVideoPhotographerName;

    @ApiModelProperty("简易视频摄影编号")
    @TableField("simple_video_photographer_num")
    private String simpleVideoPhotographerNum;

    @ApiModelProperty("简易视频摄影状态-0为未完成,1为进行中,2为已完成,3为不需要处理")
    @TableField("simple_video_status")
    private Integer simpleVideoStatus;

    @ApiModelProperty("简易视频完成时间")
    @TableField("simple_video_complete_time")
    private Integer simpleVideoCompleteTime;

    @ApiModelProperty("摄影完成是否推送开发消息，0否1是")
    @TableField("is_push_dev")
    private Integer isPushDev;

    @ApiModelProperty("是否上传后台备注")
    @TableField("plane_design_1_remark")
    private String planeDesign1Remark;

    @ApiModelProperty("视频是否侵权：0-否，1-是")
    @TableField("video_is_tort")
    private Integer videoIsTort;

    @ApiModelProperty("视频侵权意见")
    @TableField("video_tort_reason")
    private String videoTortReason;

    @ApiModelProperty(value = "是否改变了简易视频拍摄状态：0-否，1-是")
    private Integer isChangeSimpleVideoStatus;

}
