package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉设计协同系统-A+策划
 * </p>
 *
 * @author guokunkun
 * @since 2025-10-15
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_a_plus_plan")
@ApiModel(value = "VisualAPlusPlan对象", description = "视觉设计协同系统-A+策划")
public class VisualAPlusPlan implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("标题")
    @TableField("title")
    private String title;

    @ApiModelProperty("执行者")
    @TableField("executor_name")
    private String executorName;

    @ApiModelProperty("执行者编号")
    @TableField("executor_number")
    private String executorNumber;

    @ApiModelProperty("样品到货时间")
    @TableField("sample_delivery_time")
    private Integer sampleDeliveryTime;

    @ApiModelProperty("是否到样品,0-否，1-是")
    @TableField("is_have_sample")
    private Integer isHaveSample;

    @ApiModelProperty("是否需要摄影,0-否，1-是，2-P图")
    @TableField("is_need_photographer")
    private Integer isNeedPhotographer;

    @ApiModelProperty("是否有后台文案,0-否，1-是")
    @TableField("is_backstage_copywriting")
    private Integer isBackstageCopywriting;

    @ApiModelProperty("状态，0-未完成，1-进行中，2-完成,3-不需要处理")
    @TableField("`status`")
    private Integer status;

    @ApiModelProperty("状态为不需要处理时的原因：1-过季，2-断货无样品，3-开发要求不做，4-其他原因")
    @TableField("no_handle_reason")
    private Integer noHandleReason;

    @ApiModelProperty("产品id（待确定是否去除，暂时无值）")
    @TableField("product_id")
    private Long productId;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("首个发起申请的sku")
    @TableField("apply_sku")
    private String applySku;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("优先级")
    @TableField("priority")
    private String priority;

    @ApiModelProperty("标签id(visual_design_tag的id)")
    @TableField("vdt_id")
    private Long vdtId;

    @ApiModelProperty("风险检测")
    @TableField("risk_check_area")
    private String riskCheckArea;

    @ApiModelProperty("风险检测状态,0-否，1-是[对应inv的is_submit]")
    @TableField("risk_check_status")
    private Integer riskCheckStatus;

    @ApiModelProperty("文件url")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("添加地区")
    @TableField("add_region")
    private String addRegion;

    @ApiModelProperty("是否为精品产品，0-否，1-是")
    @TableField("is_boutique_product")
    private Integer isBoutiqueProduct;

    @ApiModelProperty("数据来源，0-默认，1-A+,2-A+品牌故事")
    @TableField("data_source")
    private Integer dataSource;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("策划完成时间")
    @TableField("finish_time")
    private Integer finishTime;

    @ApiModelProperty("是否需要翻译")
    @TableField("is_translate")
    private Integer isTranslate;

    @ApiModelProperty("翻译语种")
    @TableField("languages")
    private String languages;

    @ApiModelProperty("样品状态:1-正，2-次")
    @TableField("sample_status")
    private Integer sampleStatus;

    @ApiModelProperty("样品备注")
    @TableField("sample_status_remark")
    private String sampleStatusRemark;

    @ApiModelProperty("样品全部到货时间")
    @TableField("sample_arrive_time")
    private Integer sampleArriveTime;

    @ApiModelProperty("权重")
    @TableField("weight")
    private BigDecimal weight;

    @ApiModelProperty("是否走流程，0-否，1-是")
    @TableField("follow_the_process")
    private Integer followTheProcess;

    @ApiModelProperty("图片协同表的id")
    @TableField("photo_progress_id")
    private Long photoProgressId;

    @ApiModelProperty("其他原因备注")
    @TableField("no_handle_other_reason_remark")
    private String noHandleOtherReasonRemark;


}
