package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉设计协同系统-传达设计
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-07
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_communication_design")
@ApiModel(value = "VisualCommunicationDesign对象", description = "视觉设计协同系统-传达设计")
public class VisualCommunicationDesign implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("标题")
    @TableField("title")
    private String title;

    @ApiModelProperty("状态,0-未完成，1-进行中，2-完成，3-暂停/不需要处理")
    @TableField("`status`")
    private Integer status;

    @ApiModelProperty("执行者编号")
    @TableField("executor_number")
    private String executorNumber;

    @ApiModelProperty("执行者")
    @TableField("executor_name")
    private String executorName;

    @ApiModelProperty("任务完成时间")
    @TableField("task_finish_time")
    private Integer taskFinishTime;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("视频策划备注")
    @TableField("video_plan_remark")
    private String videoPlanRemark;

    @ApiModelProperty("摄影进度")
    @TableField("photo_progress")
    private Integer photoProgress;

    @ApiModelProperty("优先级/紧急程度")
    @TableField("priority")
    private String priority;

    @ApiModelProperty("标签id")
    @TableField("vdt_id")
    private Long vdtId;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("任务地区")
    @TableField("add_region")
    private String addRegion;

    @ApiModelProperty("线稿申请id,line_draft_apply表的id[待系统迁移完成，待确定是否去除]")
    @TableField("line_draft_apply_id")
    private Long lineDraftApplyId;

    @ApiModelProperty("visual_video_plan表id[待系统迁移完成，待确定是否去除]")
    @TableField("visual_video_plan_id")
    private Long visualVideoPlanId;

    @ApiModelProperty("visual_a_plus_plan表id[待系统迁移完成，待确定是否去除]")
    @TableField("a_plus_plan_id")
    private Long aPlusPlanId;

    @ApiModelProperty("是否确认排版，0-未确认，1-已确认")
    @TableField("is_confirm_typesetting")
    private Integer isConfirmTypesetting;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("分配时间")
    @TableField("assign_time")
    private Integer assignTime;

    @ApiModelProperty("品牌名是否丢失,0-否，1-是")
    @TableField("is_lost_brand")
    private Integer isLostBrand;

    @ApiModelProperty("是否为精品产品，0-否，1-是")
    @TableField("is_boutique_product")
    private Integer isBoutiqueProduct;

    @ApiModelProperty("A+文档[压缩包](account_file)")
    @TableField("ap_zip_file_url")
    private String apZipFileUrl;

    @ApiModelProperty("完整样机图")
    @TableField("complete_prototype_pic")
    private String completePrototypePic;

    @ApiModelProperty("文件URL(上传文件(文档，图片))(appendix_file)")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("设计文件(上传LOGO素材文档(压缩包))")
    @TableField("design_file")
    private String designFile;

    @ApiModelProperty("设计文件上传时间")
    @TableField("design_file_time")
    private Integer designFileTime;

    @ApiModelProperty("拍摄视频封面文档(visual_file)")
    @TableField("cover_file")
    private String coverFile;

    @ApiModelProperty("关联表id")
    @TableField("relation_id")
    private Long relationId;

    @ApiModelProperty("关联类型，visual_video_plan，visual_a_plus_plan,line_draft_apply,brand_record_tool")
    @TableField("relation_type")
    private String relationType;

    @ApiModelProperty("添加品牌备案人员")
    @TableField("add_brand_user")
    private String addBrandUser;

    @ApiModelProperty("翻译站点")
    @TableField("translate_language")
    private String translateLanguage;

    @ApiModelProperty("是否还样，0-否，1-是")
    @TableField("is_return_sample")
    private Integer isReturnSample;

    @ApiModelProperty("还样时间，是否还样为是时，需要有值")
    @TableField("return_sample_time")
    private Integer returnSampleTime;

    @ApiModelProperty("还样样品状态:1-正，2-次")
    @TableField("return_sample_status")
    private Integer returnSampleStatus;

    @ApiModelProperty("还样样品备注")
    @TableField("return_sample_status_remark")
    private String returnSampleStatusRemark;

    @ApiModelProperty("样品是否给摄影，0-否，1-是")
    @TableField("is_photography_sample")
    private Integer isPhotographySample;

    @ApiModelProperty("样品给摄影的时间，样品是否给摄影为是时，需要有值")
    @TableField("photography_sample_time")
    private Integer photographySampleTime;

    @ApiModelProperty("摄影样品状态::1-正，2-次")
    @TableField("photography_sample_status")
    private Integer photographySampleStatus;

    @ApiModelProperty("摄影样品备注")
    @TableField("photography_sample_status_remark")
    private String photographySampleStatusRemark;

    @ApiModelProperty("logo压缩包链接")
    @TableField("logo_file_url")
    private String logoFileUrl;

    @ApiModelProperty("官网文档压缩包url")
    @TableField("official_document_zip_url")
    private String officialDocumentZipUrl;

    @ApiModelProperty("品牌紧急度")
    @TableField("brand_urgency")
    private String brandUrgency;

    @ApiModelProperty("线稿压缩包url")
    @TableField("line_draft_zip_url")
    private String lineDraftZipUrl;

    @ApiModelProperty("是否套装，0-否，1-是")
    @TableField("suit_flag")
    private Integer suitFlag;

    @ApiModelProperty("通用压缩包url（用于包材标签）")
    @TableField("common_zip_url")
    private String commonZipUrl;

    @ApiModelProperty("创作目的")
    @TableField("creative_aims")
    private String creativeAims;

    @ApiModelProperty("创作独创性")
    @TableField("creative_originality")
    private String creativeOriginality;

    @ApiModelProperty("是否公示logo：0-否，1-是")
    @TableField("is_public_logo")
    private Integer isPublicLogo;

    @ApiModelProperty("权重")
    @TableField("weight")
    private BigDecimal weight;

    @ApiModelProperty("评优图片")
    @TableField("appraising_img_url")
    private String appraisingImgUrl;


}
