package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉操作日志
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-19
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_design_log")
@ApiModel(value = "VisualDesignLog对象", description = "视觉操作日志")
public class VisualDesignLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("操作")
    @TableField("operation_key")
    private String operationKey;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("操作内容")
    @TableField("operation_content")
    private String operationContent;

    @ApiModelProperty("关联id")
    @TableField("relation_id")
    private Long relationId;

    @ApiModelProperty("文件url")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("操作字段")
    @TableField("operation_type")
    private String operationType;

    @ApiModelProperty("审核状态")
    @TableField("audit_status")
    private Integer auditStatus;

    @ApiModelProperty("操作备注")
    @TableField("operation_remark")
    private String operationRemark;


}
