package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 开发-平面设计任务自动分配表
 * </p>
 *
 * @author guokunkun
 * @since 2025-10-14
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_developer_plane_design_assignment")
@ApiModel(value = "VisualDeveloperPlaneDesignAssignment对象", description = "开发-平面设计任务自动分配表")
public class VisualDeveloperPlaneDesignAssignment implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("文档链接")
    @TableField("doc_url")
    private String docUrl;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("开发编号")
    @TableField("developer_num")
    private String developerNum;

    @ApiModelProperty("开发备注")
    @TableField("developer_remark")
    private String developerRemark;

    @ApiModelProperty("类型：1-首图,2-附图,3-优化 ")
    @TableField("task_type")
    private Integer taskType;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建时间(开发提交时间)")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("发货时间（所有sku中最早的）")
    @TableField("shipment_time")
    private Integer shipmentTime;

    @ApiModelProperty("开售时间（所有sku中最早的）")
    @TableField("sale_time")
    private Integer saleTime;

    @ApiModelProperty("平面设计名字")
    @TableField("plane_design_name")
    private String planeDesignName;

    @ApiModelProperty("平面设计编号")
    @TableField("plane_design_num")
    private String planeDesignNum;

    @ApiModelProperty("分配时间")
    @TableField("assignment_time")
    private Integer assignmentTime;

    @ApiModelProperty("平面设计状态： 0-未完成,1-设计中,2-已完成")
    @TableField("plane_design_status")
    private Integer planeDesignStatus;

    @ApiModelProperty("完成时间")
    @TableField("finish_time")
    private Integer finishTime;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("风险检测")
    @TableField("risk_detection")
    private String riskDetection;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;


}
