package cn.kk.spring_simple_operation.enums;

import java.util.Arrays;

/**
 * @description: 视觉操作  进度枚举
 * @author: Devin
 * @date: 2022-09-19
 */
public enum StatusEnum {

    /** 状态，0-未完成，1-进行中，2-完成,3-不需要处理 */
    UNFINISHED(0, "未完成"),
    IN_PROGRESS(1, "进行中"),
    FINISH(2, "完成"),
    NO_NEED_HANDLE(3, "不需要处理"),// 这个状态，目前废弃了，不要用了
    DEVELOPER_NO_NEED_HANDLE(4, "开发选择不需要处理"),
    PHOTOGRAPHY_NO_NEED_HANDLE(5, "摄影选择不需要处理"),
    SALE_NO_NEED_HANDLE(6, "不在建议拍摄类目中"),




            ;


    private final Integer code;

    private final String message;

    StatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static String get(Integer code){
        StatusEnum statusEnum = Arrays.stream(StatusEnum.values()).filter(e -> code.equals(e.getCode())).findAny().orElse(null);
        if(statusEnum != null){
            return statusEnum.getMessage();
        }
        return "";
    }
}
