package cn.kk.spring_simple_operation;

import cn.kk.spring_simple_operation.mapper.SyncProductAuditMapper;
import cn.kk.spring_simple_operation.model.ExportPhotographerNameVO;
import cn.kk.spring_simple_operation.utils.ExcelUtil;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author kk
 * @date 2025/2/6
 */
@SpringBootTest
public class ExportPhotographerTest {

	@Resource
	private SyncProductAuditMapper syncProductAuditMapper;

	@Test
	void contextLoads() {
		List<ExportPhotographerNameVO> list = syncProductAuditMapper.selectIsCustomProdduct();
		ExcelUtil<ExportPhotographerNameVO> util = new ExcelUtil<>(ExportPhotographerNameVO.class);
		util.exportExcelFile(list, "有样品但是未到样&未上传的任务");
	}

	@Test
	void contextLoad_2() {
		List<ExportPhotographerNameVO> list = syncProductAuditMapper.selectIsCustomProdductPlan();
		ExcelUtil<ExportPhotographerNameVO> util = new ExcelUtil<>(ExportPhotographerNameVO.class);
		util.exportExcelFile(list, "断货无样品");
	}
}
