package cn.kk.spring_simple_operation;

import cn.kk.spring_simple_operation.entity.SyncProductPublish;
import cn.kk.spring_simple_operation.mapper.SyncProductAuditMapper;
import cn.kk.spring_simple_operation.mapper.SyncProductPublishMapper;
import cn.kk.spring_simple_operation.mapper.VideoProductMapper;
import cn.kk.spring_simple_operation.model.SkuVideoVO;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@SpringBootTest
class SpringSimpleOperationApplicationTests2 {

	private static final BigDecimal               TWENTY = new BigDecimal("20");
	private static final BigDecimal               THIRTY = new BigDecimal("30");
	private static final BigDecimal               FORTY  = new BigDecimal("40");
	private static final BigDecimal               SIXTY  = new BigDecimal("60");
	@Resource
	private              SyncProductPublishMapper syncProductPublishMapper;

	@Resource
	private VideoProductMapper videoProductMapper;

	@Resource
	private SyncProductAuditMapper syncProductAuditMapper;


	@Test
	void contextLoads() {
	}

	private Map<String, Integer> initSalesMap() {
		Map<String, Integer> salesMap = new HashMap<>();
		salesMap.put("0~20", 0);
		salesMap.put("20~30", 0);
		salesMap.put("30~40", 0);
		salesMap.put("40~60", 0);
		salesMap.put(">60", 0);
		return salesMap;
	}

	@Test
	void singleSkuSolarTerm_1() {
		//List<String> shortUrlSkuList = videoProductMapper.selectHaveTask();

		Map<String, Integer> salesMap = initSalesMap();

		List<SkuVideoVO> publishList = syncProductPublishMapper.selectChildSku();
		List<SkuVideoVO> publishList_2 = new LinkedList<>();

		publishList.forEach(item -> {
			ArrayList<SkuVideoVO> list = new ArrayList<>();
			list.add(item);
			String s = checkPriceAndSales(list, item);
			if (StringUtils.isBlank(s)) {
				return;
			}
			salesMap.put(s, salesMap.get(s) + 1);
			publishList_2.add(item);
		});
		printMap(salesMap);
		exportSkuList(publishList_2, "常规产品--单个sku");
	}

	@Test
	void groupSkuSolarTerm_1() {
		//List<String> shortUrlSkuList = videoProductMapper.selectHaveTask();

		Map<String, Integer> salesMap = initSalesMap();

		List<String> motherList = syncProductAuditMapper.groupSkuSolarTerm_1();

		List<SkuVideoVO> publishList_2 = new LinkedList<>();

		motherList.forEach(sku -> {
			List<SkuVideoVO> skuVideoVOS = syncProductPublishMapper.groupSkuSolarTerm_1(sku);
			Optional<SkuVideoVO> first = skuVideoVOS.stream().filter(t -> t.getSku().equals(sku)).findFirst();
			if (!first.isPresent()) {
				return;
			}
			List<String> shortUrlSkuList = videoProductMapper.selectHaveTask(skuVideoVOS.stream().map(SkuVideoVO::getSku).collect(Collectors.toList()));
			Iterator<SkuVideoVO> iterator = skuVideoVOS.iterator();
			while (iterator.hasNext()) {
				SkuVideoVO skuVideoVO = iterator.next();
				if (shortUrlSkuList.contains(skuVideoVO.getSku())) {
					iterator.remove();
				}
			}
			if (CollectionUtils.isEmpty(skuVideoVOS)) {
				return;
			}
			String s = checkPriceAndSales(skuVideoVOS, first.get());
			if (StringUtils.isBlank(s)) {
				return;
			}
			salesMap.put(s, salesMap.get(s) + 1);
			publishList_2.add(first.get());

		});

		printMap(salesMap);
		exportSkuList(publishList_2, "常规产品--组合产品母体sku");

	}

	private String checkPriceAndSales(List<SkuVideoVO> subList, SkuVideoVO item) {
		BigDecimal totalPrice = subList.stream().map(SkuVideoVO::getLowestPrice).reduce(BigDecimal::add).get();
		BigDecimal lowestPrice = totalPrice.divide(new BigDecimal(subList.size()), 2, BigDecimal.ROUND_HALF_UP);

		if (CollectionUtils.isEmpty(subList) || lowestPrice.compareTo(BigDecimal.ZERO) < 0) {
			return null;
		}
		int sum = subList.stream().map(SkuVideoVO::getThirtyDaySales).reduce(Integer::sum).get();
		item.setThirtyDaySales(sum);
		item.setLowestPrice(lowestPrice);
		if (lowestPrice.compareTo(TWENTY) <= 0 && sum >= 25) {
			return "0~20";
		}
		else if (lowestPrice.compareTo(TWENTY) > 0 && lowestPrice.compareTo(THIRTY) <= 0 && sum >= 15) {
			return "20~30";
		}
		else if (lowestPrice.compareTo(THIRTY) > 0 && lowestPrice.compareTo(FORTY) <= 0 && sum >= 10) {
			return "30~40";
		}
		else if (lowestPrice.compareTo(FORTY) > 0 && lowestPrice.compareTo(SIXTY) <= 0 && sum >= 8) {
			return "40~60";
		}
		else if (lowestPrice.compareTo(SIXTY) > 0 && sum >= 5) {
			return ">60";
		}
		return null;
	}

	private void printSkuList(List<SyncProductPublish> list) {
		list.forEach(item -> {
			String content = String.format("sku: %s, 30天销量: %d, price: %s, relationKey: %s, parentAsin: %s", item.getSku(), item.getThirtyDaySales(), item.getLowestPrice(), item.getRelationKey(), item.getParentAsin());
			System.out.println(content);
		});
	}

	private void exportSkuList(List<SkuVideoVO> list, String originName) {
		list.sort(Comparator.comparing(SkuVideoVO::getLowestPrice));
		List<List<Object>> dataList = ListUtils.newArrayList();
		for (SkuVideoVO syncProductPublish : list) {
			List<Object> data = ListUtils.newArrayList();
			data.add(syncProductPublish.getSku());
			data.add(syncProductPublish.getLowestPrice());
			data.add(syncProductPublish.getThirtyDaySales());
			data.add(syncProductPublish.getSaleStatus());
			data.add(syncProductPublish.getUsUploadInfo());
			dataList.add(data);
		}

		// 写法1
		String fileName = "D:\\" + originName + "_" + System.currentTimeMillis() + ".xlsx";
		// 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
		EasyExcel.write(fileName).head(head()).sheet(originName).doWrite(dataList);
	}

	private void printMap(Map<String, Integer> salesMap) {
		System.out.println("0~20: " + salesMap.get("0~20"));
		System.out.println("20~30: " + salesMap.get("20~30"));
		System.out.println("30~40: " + salesMap.get("30~40"));
		System.out.println("40~60: " + salesMap.get("40~60"));
		System.out.println(">60: " + salesMap.get(">60"));
	}

	private List<List<String>> head() {
		List<List<String>> list = ListUtils.newArrayList();
		List<String> head0 = ListUtils.newArrayList();
		head0.add("sku");
		List<String> head1 = ListUtils.newArrayList();
		head1.add("单价");
		List<String> head2 = ListUtils.newArrayList();
		head2.add("月销");
		List<String> head3 = ListUtils.newArrayList();
		head3.add("销售状态");
		List<String> head4 = ListUtils.newArrayList();
		head4.add("是否拍摄");
		list.add(head0);
		list.add(head1);
		list.add(head2);
		list.add(head3);
		list.add(head4);
		return list;
	}


	@Test
	void singleSkuSolarTerm_Q1Q2() {

		Map<String, Integer> salesMap = initSalesMap();

		List<SkuVideoVO> publishList = syncProductPublishMapper.selectChildSku_2();
		List<SkuVideoVO> publishList_2 = new LinkedList<>();

		publishList.forEach(item -> {
			ArrayList<SkuVideoVO> list = new ArrayList<>();
			list.add(item);
			String s = checkPriceAndSales(list, item);
			if (StringUtils.isBlank(s)) {
				return;
			}
			salesMap.put(s, salesMap.get(s) + 1);
			publishList_2.add(item);
		});
		printMap(salesMap);
		exportSkuList(publishList_2, "节气产品--单个sku");
	}

	@Test
	void groupSkuSolarTerm_Q1Q2() {
		//List<String> shortUrlSkuList = videoProductMapper.selectHaveTask();

		Map<String, Integer> salesMap = initSalesMap();

		List<String> motherList = syncProductAuditMapper.groupSkuSolarTerm_Q1Q2();

		List<SkuVideoVO> publishList_2 = new LinkedList<>();

		motherList.forEach(sku -> {
			List<SkuVideoVO> skuVideoVOS = syncProductPublishMapper.groupSkuSolarTerm_Q1Q2(sku);
			Optional<SkuVideoVO> first = skuVideoVOS.stream().filter(t -> t.getSku().equals(sku)).findFirst();
			if (!first.isPresent()) {
				return;
			}
			List<String> shortUrlSkuList = videoProductMapper.selectHaveTask(skuVideoVOS.stream().map(SkuVideoVO::getSku).collect(Collectors.toList()));
			skuVideoVOS.removeIf(skuVideoVO -> shortUrlSkuList.contains(skuVideoVO.getSku()));
			if (CollectionUtils.isEmpty(skuVideoVOS)) {
				return;
			}
			String s = checkPriceAndSales(skuVideoVOS, first.get());
			if (StringUtils.isBlank(s)) {
				return;
			}
			salesMap.put(s, salesMap.get(s) + 1);
			publishList_2.add(first.get());

		});

		printMap(salesMap);
		exportSkuList(publishList_2, "节气产品--组合产品母体sku");

	}

}
