package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 图片协同系统
 * </p>
 *
 * @author guokunkun
 * @since 2024-12-25
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("photo_progress")
@ApiModel(value = "PhotoProgress对象", description = "图片协同系统")
public class PhotoProgress implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("审核产品id")
    @TableField("product_id")
    private Integer productId;

    @TableField("sku")
    private String sku;

    @ApiModelProperty("创建时间")
    @TableField("create_at")
    private Integer createAt;

    @ApiModelProperty("更新时间")
    @TableField("update_at")
    private Integer updateAt;

    @ApiModelProperty("0-未发送，1-已发送，默认未发送")
    @TableField("is_send")
    private Integer isSend;

    @ApiModelProperty("1-新产品，2-老产品优化。默认1")
    @TableField("pic_product_type")
    private Integer picProductType;

    @ApiModelProperty("加急申请，0未加急，1-加急，默认加急")
    @TableField("is_urgent")
    private Integer isUrgent;

    @ApiModelProperty("加急申请通过状态，1-加急通过，0加急未通过，默认0")
    @TableField("urgent_is_pass")
    private Integer urgentIsPass;

    @ApiModelProperty("文档上传时间")
    @TableField("upload_time")
    private Integer uploadTime;

    @ApiModelProperty("样品状态，0-未接，1-已接。")
    @TableField("sample_status")
    private Integer sampleStatus;

    @ApiModelProperty("加急申请理由")
    @TableField("urgent_reason")
    private String urgentReason;

    @ApiModelProperty("加急申请发送，0-未发送,1-已发送， ")
    @TableField("is_send_urgent")
    private Integer isSendUrgent;

    @ApiModelProperty("审批内容")
    @TableField("audit_content")
    private String auditContent;

    @ApiModelProperty("文档是否上传，0-未上传，1-已上传")
    @TableField("is_upload_doc")
    private Integer isUploadDoc;

    @ApiModelProperty("文档")
    @TableField("project_file")
    private String projectFile;

    @ApiModelProperty("销售上传的文档")
    @TableField("project_sale_file")
    private String projectSaleFile;

    @ApiModelProperty("销售上传的文档审核状态：0-销售未传图需,1-等待开发审核,2-审核通过,3-审核不通过")
    @TableField("project_sale_file_status")
    private Integer projectSaleFileStatus;

    @ApiModelProperty("销售上传的文档审核时间")
    @TableField("project_sale_file_audit_time")
    private Integer projectSaleFileAuditTime;

    @ApiModelProperty("销售上传的文档审核不通过的原因")
    @TableField("project_sale_file_reason")
    private String projectSaleFileReason;

    @ApiModelProperty("文档是否下载，0-未下载，1-已下载")
    @TableField("is_download_doc")
    private Integer isDownloadDoc;

    @ApiModelProperty("文档下载时间")
    @TableField("download_time")
    private Integer downloadTime;

    @ApiModelProperty("开发发送图片给摄影的时间")
    @TableField("pic_send_time")
    private Integer picSendTime;

    @ApiModelProperty(" 样品接收时间")
    @TableField("recieve_time")
    private Integer recieveTime;

    @ApiModelProperty("申请修改平面的理由")
    @TableField("apply_modify_plane_reason")
    private String applyModifyPlaneReason;

    @ApiModelProperty("平面申请审核内容")
    @TableField("plane_audit_content")
    private String planeAuditContent;

    @ApiModelProperty("0默认,1通过，2未通过")
    @TableField("plane_is_pass")
    private Integer planeIsPass;

    @ApiModelProperty("是否申请修改平面设计，1是，0否")
    @TableField("is_apply_modify_plane")
    private Integer isApplyModifyPlane;

    @ApiModelProperty("文件名")
    @TableField("file_name")
    private String fileName;

    @ApiModelProperty("开售时间")
    @TableField("sale_time")
    private Integer saleTime;

    @ApiModelProperty("重拍次数")
    @TableField("re_take_times")
    private Integer reTakeTimes;

    @ApiModelProperty("发货时间")
    @TableField("shipment_time")
    private Integer shipmentTime;

    @ApiModelProperty("入正品仓时间")
    @TableField("stock_in_time")
    private Integer stockInTime;

    @ApiModelProperty("质检时间")
    @TableField("check_time")
    private Integer checkTime;

    @ApiModelProperty("验收时间")
    @TableField("accept_time")
    private Integer acceptTime;

    @ApiModelProperty("采购时间")
    @TableField("purchase_time")
    private Integer purchaseTime;

    @ApiModelProperty("重拍备注")
    @TableField("re_take_remark")
    private String reTakeRemark;

    @ApiModelProperty("重拍时间")
    @TableField("re_take_at")
    private Integer reTakeAt;

    @ApiModelProperty("上传文档备注")
    @TableField("doc_remark")
    private String docRemark;

    @ApiModelProperty("asin")
    @TableField("asin")
    private String asin;

    @ApiModelProperty("关键词")
    @TableField("keywords")
    private String keywords;

    @ApiModelProperty("链接")
    @TableField("reference_link")
    private String referenceLink;

    @ApiModelProperty("1-已提交 0-未提交")
    @TableField("is_submit_visual")
    private Integer isSubmitVisual;

    @ApiModelProperty("提交时间")
    @TableField("submit_visual_time")
    private Integer submitVisualTime;

    @ApiModelProperty("1-已保存草稿 0-未保存")
    @TableField("is_save_draft")
    private Integer isSaveDraft;

    @ApiModelProperty("保存草稿时间")
    @TableField("save_draft_time")
    private Integer saveDraftTime;

    @ApiModelProperty("风险检测")
    @TableField("risk_detection")
    private String riskDetection;

    @TableField("ctr")
    private BigDecimal ctr;

    @ApiModelProperty("简易视频上传状态-0为未上传,1为已上传,2-其他,3-暂未上传 5-已删除")
    @TableField("simple_video_upload_status")
    private Integer simpleVideoUploadStatus;

    @ApiModelProperty("简易视频上传时间")
    @TableField("simple_video_upload_time")
    private Integer simpleVideoUploadTime;

    @ApiModelProperty("简易视频备注")
    @TableField("simple_video_remark")
    private String simpleVideoRemark;

    @ApiModelProperty("是否创建SBV")
    @TableField("is_create_sbv")
    private Integer isCreateSbv;

    @ApiModelProperty("未创建sbv备注")
    @TableField("sbv_remark")
    private String sbvRemark;

    @ApiModelProperty("备注类型枚举")
    @TableField("sbv_remark_type")
    private Integer sbvRemarkType;

    @ApiModelProperty("前台是否有视频")
    @TableField("is_video_in_amazon")
    private Integer isVideoInAmazon;

    @ApiModelProperty("发货方式0默认空，1空运，2海运，3空运和海运")
    @TableField("transport_mode")
    private Integer transportMode;

    @ApiModelProperty("是否需要拍图 （0-否，1-是，2-请选择）")
    @TableField("is_photo")
    private Integer isPhoto;

    @ApiModelProperty("简易视频地址")
    @TableField("simple_video_url")
    private String simpleVideoUrl;

    @ApiModelProperty("同步sku")
    @TableField("sync_sku")
    private String syncSku;

    @ApiModelProperty("图片开发备注")
    @TableField("photo_dev_remark")
    private String photoDevRemark;

    @ApiModelProperty("是否上传后台备注")
    @TableField("upload_remark")
    private String uploadRemark;

    @ApiModelProperty("简易视频上传人")
    @TableField("simple_video_upload_name")
    private String simpleVideoUploadName;

    @ApiModelProperty("首次接收时间")
    @TableField("first_receive_time")
    private Integer firstReceiveTime;


}
