package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉设计人员信息
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-19
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_designer")
@ApiModel(value = "VisualDesigner对象", description = "视觉设计人员信息")
public class VisualDesigner implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("用户id")
    @TableField("user_id")
    private Integer userId;

    @ApiModelProperty("部门key")
    @TableField("department_key")
    private String departmentKey;

    @ApiModelProperty("用户名称")
    @TableField("user_name")
    private String userName;

    @ApiModelProperty("角色id")
    @TableField("role_id")
    private Integer roleId;

    @ApiModelProperty("部门名称")
    @TableField("department_name")
    private String departmentName;

    @ApiModelProperty("分组编号")
    @TableField("group_number")
    private String groupNumber;

    @ApiModelProperty("职位")
    @TableField("user_position")
    private String userPosition;

    @ApiModelProperty("编号")
    @TableField("visual_number")
    private String visualNumber;

    @ApiModelProperty("等级")
    @TableField("visual_level")
    private String visualLevel;

    @ApiModelProperty("管理部门(显示的字符串)")
    @TableField("manage_department")
    private String manageDepartment;

    @ApiModelProperty("管理分组(显示的字符串)")
    @TableField("manage_group")
    private String manageGroup;

    @ApiModelProperty("创建用户id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建用户")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("是否删除，0-否1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("负责的开发名称(显示的字符串,摄影负责开发)")
    @TableField("develop_name")
    private String developName;

    @ApiModelProperty("负责的开发编号(显示的字符串,图案设计负责开发)")
    @TableField("developer_num")
    private String developerNum;

    @ApiModelProperty("负责的账号(显示的字符串,策划负责账号)")
    @TableField("account_name")
    private String accountName;

    @ApiModelProperty("摄影助理用户id")
    @TableField("photographer_assistant")
    private Integer photographerAssistant;

    @ApiModelProperty("地区")
    @TableField("region")
    private String region;

    @ApiModelProperty("地区(城市)")
    @TableField("region_city")
    private String regionCity;

    @ApiModelProperty("摄影A+关联的传达设计人员编号，逗号分隔")
    @TableField("communication_designer")
    private String communicationDesigner;

    @ApiModelProperty("摄影关联的策划人员编号，以英文逗号分隔")
    @TableField("relevance_plan")
    private String relevancePlan;

    @ApiModelProperty("是否在摄影A+页面展示")
    @TableField("is_show_in_a_plus")
    private Integer isShowInAPlus;

    @ApiModelProperty("是否为优秀设计师:0-否，1-是")
    @TableField("is_excellent_designer")
    private Integer isExcellentDesigner;

    @ApiModelProperty("额度(若填了【可选设计师的开发】则展示，只可填正整数)")
    @TableField("quota")
    private Integer quota;

    @ApiModelProperty("更新时间(用于数据同步)")
    @TableField("update_at")
    private LocalDateTime updateAt;

    @ApiModelProperty("是否为剪辑师:0-否，1-是")
    @TableField("is_editor")
    private Integer isEditor;

    @ApiModelProperty("是否在摄影视频页面展示：0-否，1-是")
    @TableField("is_show_in_photographer")
    private Integer isShowInPhotographer;


}
