package cn.kk.spring_simple_operation.service.impl;

import cn.kk.spring_simple_operation.entity.DeptGroup;
import cn.kk.spring_simple_operation.mapper.DeptGroupMapper;
import cn.kk.spring_simple_operation.service.DeptGroupService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 各部门分组表 服务实现类
 * </p>
 *
 * @author guokunkun
 * @since 2025-05-26
 */
@Service
public class DeptGroupServiceImpl extends ServiceImpl<DeptGroupMapper, DeptGroup> implements DeptGroupService {

	@Override
	public List<String> getDeveloperNumByNodePathList(String module, List<String> nodePathList) {
		if (CollectionUtils.isEmpty(nodePathList)) {
			return Collections.emptyList();
		}
		return baseMapper.getDeveloperNumByNodePathList(module, nodePathList);
	}
}
