package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

/**
 * @author guokunkun
 * @date 2023/4/24
 */
public class SelfMySqlTypeConvert extends MySqlTypeConvert implements ITypeConvert {

    @Override
    public IColumnType processTypeConvert(GlobalConfig config, String fieldType) {
        IColumnType columnType = TypeConverts.use(fieldType)
                .test(TypeConverts.containsAny(new CharSequence[]{"char", "text", "json", "enum"}).then(DbColumnType.STRING))
                .test(TypeConverts.contains("bigint").then(DbColumnType.LONG))
                .test(TypeConverts.containsAny(new CharSequence[]{"tinyint(1)", "bit(1)"}).then(DbColumnType.INTEGER))
                .test(TypeConverts.contains("bit").then(DbColumnType.BYTE))
                .test(TypeConverts.containsAny("int").then(DbColumnType.INTEGER))
                .test(TypeConverts.contains("decimal").then(DbColumnType.BIG_DECIMAL))
                .test(TypeConverts.contains("clob").then(DbColumnType.CLOB))
                .test(TypeConverts.contains("blob").then(DbColumnType.BLOB))
                .test(TypeConverts.contains("binary").then(DbColumnType.BYTE_ARRAY))
                .test(TypeConverts.contains("float").then(DbColumnType.FLOAT))
                .test(TypeConverts.contains("double").then(DbColumnType.DOUBLE))
                .test(TypeConverts.containsAny(new CharSequence[]{"date", "time", "year"}).then((t) -> toDateType(config, t)))
                .or(DbColumnType.STRING);
//        System.out.println("字段类型：：：" + fieldType + "，属性类型是：" + columnType.getType());
        return columnType;
    }
}
