package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * A+产品
 * </p>
 *
 * @author guokunkun
 * @since 2025-03-18
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("a_plus_product")
@ApiModel(value = "APlusProduct对象", description = "A+产品")
public class APlusProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("站点")
    @TableField("site")
    private String site;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("关联sku")
    @TableField("relation_sku")
    private String relationSku;

    @ApiModelProperty("关联sku站点")
    @TableField("relation_sku_site")
    private String relationSkuSite;

    @ApiModelProperty("A+上传后台30天销量")
    @TableField("sale_30")
    private Integer sale30;

    @ApiModelProperty("A+是否合格,0-否，1-是\"")
    @TableField("is_qualified")
    private Integer isQualified;

    @ApiModelProperty("A+上传后台状态,0-默认值，1-未完成，2-完成，3-不需要处理")
    @TableField("is_upload_backstage")
    private Integer isUploadBackstage;

    @ApiModelProperty("A+合格备注")
    @TableField("qualified_remark")
    private String qualifiedRemark;

    @ApiModelProperty("A+上传备注")
    @TableField("upload_remark")
    private String uploadRemark;

    @ApiModelProperty("催评原因")
    @TableField("urge_reason")
    private String urgeReason;

    @ApiModelProperty("添加地区")
    @TableField("add_region")
    private String addRegion;

    @ApiModelProperty("是否共享A+,0-否，1-是")
    @TableField("is_share_a_plus")
    private Integer isShareAPlus;

    @ApiModelProperty("[优化A+]A+优化类型：1-版面重新设计（整版调色、整版改排版）,2-老品详情页替换新品。（老品外观变更、老品侵权、批次大货不一致）；3-增加新模板设计")
    @TableField("a_plus_optimize_type")
    private Integer aPlusOptimizeType;

    @ApiModelProperty("[优化A+]是否需要A+策划,0-否，1-是")
    @TableField("is_a_plus_plan")
    private Integer isAPlusPlan;

    @ApiModelProperty("[优化A+]是否需要摄影,0-否，1-是")
    @TableField("is_photo")
    private Integer isPhoto;

    @ApiModelProperty("[优化A+]优化备注")
    @TableField("optimize_remark")
    private String optimizeRemark;

    @ApiModelProperty("添加时备注")
    @TableField("add_remark")
    private String addRemark;

    @ApiModelProperty("优化类型：0-原始任务(默认)，1-优化任务")
    @TableField("optimize_type")
    private Integer optimizeType;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("摄影A+的id,visual_photographer_a_plus表id")
    @TableField("photographer_a_plus_id")
    private Long photographerAPlusId;

    @ApiModelProperty("传达设计id,visual_communication_design表id")
    @TableField("communication_design_id")
    private Long communicationDesignId;

    @ApiModelProperty("A+上传后台时间")
    @TableField("upload_backstage_time")
    private Integer uploadBackstageTime;

    @ApiModelProperty("A+上传后台人id(inv没有值)")
    @TableField("upload_backstage_id")
    private Long uploadBackstageId;

    @ApiModelProperty("A+上传后台人")
    @TableField("upload_backstage_user")
    private String uploadBackstageUser;

    @ApiModelProperty("A+优先等级")
    @TableField("a_plus_level")
    private String aPlusLevel;

    @ApiModelProperty("visual_a_plus_plan表id")
    @TableField("a_plus_plan_id")
    private Long aPlusPlanId;

    @ApiModelProperty("相关SKU是否同步,-1-暂无，0-否，1-是")
    @TableField("is_sync")
    private Integer isSync;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("创建人类型，0-系统，1-销售，2-策划")
    @TableField("create_type")
    private Integer createType;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("是否已做A+优化 0-否 1-是")
    @TableField("is_optimize")
    private Integer isOptimize;

    @ApiModelProperty("商标审核人")
    @TableField("trademark_audit_user")
    private String trademarkAuditUser;

    @ApiModelProperty("商标审核人id")
    @TableField("trademark_audit_user_id")
    private Integer trademarkAuditUserId;

    @ApiModelProperty("商标审核状态 0待审核 1已审核 2商标问题 3拼写问题 4商标+拼写 5无问题")
    @TableField("trademark_audit_status")
    private Integer trademarkAuditStatus;

    @ApiModelProperty("商标审核时间")
    @TableField("trademark_audit_time")
    private Integer trademarkAuditTime;

    @ApiModelProperty("销售等级")
    @TableField("sales_level")
    private String salesLevel;

    @ApiModelProperty("该字段记录的是优化类型5，同站点同sku时，是否是最新的优化")
    @TableField("is_newest_optimize")
    private Integer isNewestOptimize;

    @ApiModelProperty("商标审核备注")
    @TableField("trademark_audit_memo")
    private String trademarkAuditMemo;

    @ApiModelProperty("亚马逊平台A+发布状态，0-未发布，1-已发布")
    @TableField("a_plus_publish_plat_status")
    private Integer aPlusPublishPlatStatus;


}
