package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 品牌备案工具
 * </p>
 *
 * @author guokunkun
 * @since 2025-04-01
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("brand_record_tool")
@ApiModel(value = "BrandRecordTool对象", description = "品牌备案工具")
public class BrandRecordTool implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("账号")
    @TableField("`account`")
    private String account;

    @ApiModelProperty("账号logo是否完成，0-否，1-是")
    @TableField("is_finish_logo")
    private Integer isFinishLogo;

    @ApiModelProperty("账号LOGO图")
    @TableField("account_logo_url")
    private String accountLogoUrl;

    @ApiModelProperty("是否需设计：0-请选择，1-是，2-否")
    @TableField("is_need_design")
    private Integer isNeedDesign;

    @ApiModelProperty("备案品牌")
    @TableField("record_brand")
    private String recordBrand;

    @ApiModelProperty("UK站点备案情况: 1-自备案，2-被授权，3-备案中，4-备案失败，5-授权失败")
    @TableField("record_status_uk")
    private Integer recordStatusUk;

    @ApiModelProperty("US站点备案情况: 1-自备案，2-被授权，3-备案中，4-备案失败，5-授权失败")
    @TableField("record_status_us")
    private Integer recordStatusUs;

    @ApiModelProperty("US是否可以做A+，0-否，1-是")
    @TableField("is_can_a_plus_us")
    private Integer isCanAPlusUs;

    @ApiModelProperty("UK是否可以做A+，0-否，1-是")
    @TableField("is_can_a_plus_uk")
    private Integer isCanAPlusUk;

    @ApiModelProperty("US是否可以添加视频,0-否，1-是")
    @TableField("is_add_video_us")
    private Integer isAddVideoUs;

    @ApiModelProperty("UK是否可以添加视频,0-否，1-是")
    @TableField("is_add_video_uk")
    private Integer isAddVideoUk;

    @ApiModelProperty("US注册号 ")
    @TableField("register_number_us")
    private String registerNumberUs;

    @ApiModelProperty("UK注册号")
    @TableField("register_number_uk")
    private String registerNumberUk;

    @ApiModelProperty("备注")
    @TableField("record_remark")
    private String recordRemark;

    @ApiModelProperty("创建用户id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建用户")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("设计编号(原系统未设置值，可考虑去掉)")
    @TableField("design_number")
    private String designNumber;

    @ApiModelProperty("设计人(原系统未设置值，可考虑去掉)")
    @TableField("design_name")
    private String designName;

    @ApiModelProperty("分配设计时间(原系统未设置值，可考虑去掉)")
    @TableField("design_time")
    private Integer designTime;

    @ApiModelProperty("设计上传文档时间")
    @TableField("design_upload_file_time")
    private Integer designUploadFileTime;

    @ApiModelProperty("设计上传文档")
    @TableField("design_upload_url")
    private String designUploadUrl;

    @ApiModelProperty("初审状态,0-待审核，1-审核中,2-通过，3-不通过，")
    @TableField("first_audit_status")
    private Integer firstAuditStatus;

    @ApiModelProperty("初审时间")
    @TableField("first_audit_time")
    private Integer firstAuditTime;

    @ApiModelProperty("初审人员")
    @TableField("first_audit_name")
    private String firstAuditName;

    @ApiModelProperty("初审人员id")
    @TableField("first_audit_id")
    private Integer firstAuditId;

    @ApiModelProperty("初审图片")
    @TableField("first_audit_url")
    private String firstAuditUrl;

    @ApiModelProperty("初审备注")
    @TableField("first_audit_remark")
    private String firstAuditRemark;

    @ApiModelProperty("复审状态,0-待审核，1-审核中,2-通过，3-不通过")
    @TableField("second_audit_status")
    private Integer secondAuditStatus;

    @ApiModelProperty("复审时间")
    @TableField("second_audit_time")
    private Integer secondAuditTime;

    @ApiModelProperty("复审人员id")
    @TableField("second_audit_id")
    private Integer secondAuditId;

    @ApiModelProperty("复审人员")
    @TableField("second_audit_name")
    private String secondAuditName;

    @ApiModelProperty("复审备注")
    @TableField("second_audit_remark")
    private String secondAuditRemark;

    @ApiModelProperty("US品牌权限角色0-Administrator,1-Rights Owner,2-Registered Agent,3-Administrator, Rights Owner,4-Administrator, Registered Agent")
    @TableField("us_brand_permission_role")
    private Integer usBrandPermissionRole;

    @ApiModelProperty("UK品牌权限角色,0-Administrator,1-Rights Owner,2-Registered Agent,3-Administrator, Rights Owner,4-Administrator, Registered Agent")
    @TableField("uk_brand_permission_role")
    private Integer ukBrandPermissionRole;

    @ApiModelProperty("商标类别")
    @TableField("trademark_category")
    private String trademarkCategory;

    @ApiModelProperty("设计申请原因：1-新账号品牌备案，2-解除上新报错，3-公共开发者官网域名logo设计，4-品牌申诉，5-其他（需备注具体原因）")
    @TableField("design_reason")
    private Integer designReason;

    @ApiModelProperty("设计紧急程度,可填 1 2 3")
    @TableField("design_urgency")
    private Integer designUrgency;

    @ApiModelProperty("设计申请备注")
    @TableField("design_remark")
    private String designRemark;

    @ApiModelProperty("官网文档编辑id")
    @TableField("official_document_editor_id")
    private Long officialDocumentEditorId;

    @ApiModelProperty("官网文档url")
    @TableField("official_document_url")
    private String officialDocumentUrl;

    @ApiModelProperty("官网文档申请原因：1-新账号品牌备案，2-解除上新报错，3-品牌申诉，4-申请汽配类权限，5-其他（需备注具体原因）")
    @TableField("official_document_reason")
    private Integer officialDocumentReason;

    @ApiModelProperty("官网文档紧急程度,可填 1 2 3")
    @TableField("official_document_urgency")
    private Integer officialDocumentUrgency;

    @ApiModelProperty("官网文档申请备注")
    @TableField("official_document_remark")
    private String officialDocumentRemark;

    @ApiModelProperty("官网做任务次数（优化的时候取）")
    @TableField("official_times")
    private Integer officialTimes;

    @ApiModelProperty("官网文档压缩包")
    @TableField("official_document_zip")
    private String officialDocumentZip;

    @ApiModelProperty("传达设计的id，为了让跟随安审通过的也能查到日志")
    @TableField("communication_id")
    private Long communicationId;

    @ApiModelProperty("商标类别备注")
    @TableField("trademark_category_remark")
    private String trademarkCategoryRemark;

    @ApiModelProperty("官网设计师编号")
    @TableField("official_designer_number")
    private String officialDesignerNumber;

    @ApiModelProperty("官网设计师名称")
    @TableField("official_designer_name")
    private String officialDesignerName;

    @ApiModelProperty("官网设计状态")
    @TableField("official_designer_status")
    private Integer officialDesignerStatus;

    @ApiModelProperty("官网设计完成时间")
    @TableField("official_designer_finish_time")
    private Integer officialDesignerFinishTime;

    @ApiModelProperty("logo压缩包链接")
    @TableField("logo_zip_url")
    private String logoZipUrl;

    @ApiModelProperty("US后台状态: 1-正常，2-已撤销，3-已丢失，4-已恢复")
    @TableField("backstage_status_us")
    private Integer backstageStatusUs;

    @ApiModelProperty("UK后台状态: 1-正常，2-已撤销，3-已丢失，4-已恢复")
    @TableField("backstage_status_uk")
    private Integer backstageStatusUk;

    @ApiModelProperty("US广告系统是否有抓取：0-否，1-是")
    @TableField("capture_advertisements_us")
    private Integer captureAdvertisementsUs;

    @ApiModelProperty("UK广告系统是否有抓取：0-否，1-是")
    @TableField("capture_advertisements_uk")
    private Integer captureAdvertisementsUk;

    @ApiModelProperty("US序列号")
    @TableField("serial_number_us")
    private String serialNumberUs;

    @ApiModelProperty("brand id")
    @TableField("brand_id")
    private String brandId;

    @ApiModelProperty("US被授权账号")
    @TableField("empower_account_us")
    private String empowerAccountUs;

    @ApiModelProperty("UK被授权账号")
    @TableField("empower_account_uk")
    private String empowerAccountUk;

    @ApiModelProperty("传达设计官网任务的id，共享官网任务")
    @TableField("communication_official_id")
    private Long communicationOfficialId;

    @ApiModelProperty("旗舰店项目文档编辑id")
    @TableField("flagship_project_editor_id")
    private Long flagshipProjectEditorId;

    @ApiModelProperty("旗舰店项目文档url")
    @TableField("flagship_project_url")
    private String flagshipProjectUrl;

    @ApiModelProperty("旗舰店网址")
    @TableField("flagship_project_website")
    private String flagshipProjectWebsite;

    @ApiModelProperty("旗舰店项目申请原因：1-新账号品牌备案，2-解除上新报错，3-品牌申诉，4-申请汽配类权限，5-其他（需备注具体原因）")
    @TableField("flagship_project_reason")
    private Integer flagshipProjectReason;

    @ApiModelProperty("旗舰店项目紧急程度：可填 1 2 3")
    @TableField("flagship_project_urgency")
    private Integer flagshipProjectUrgency;

    @ApiModelProperty("旗舰店项目申请备注")
    @TableField("flagship_project_remark")
    private String flagshipProjectRemark;

    @ApiModelProperty("旗舰店做任务次数（优化的时候取）")
    @TableField("flagship_times")
    private Integer flagshipTimes;

    @ApiModelProperty("旗舰店压缩包")
    @TableField("flagship_project_zip")
    private String flagshipProjectZip;

    @ApiModelProperty("传达设计旗舰店项目的id，共享官网任务")
    @TableField("communication_flagship_id")
    private Long communicationFlagshipId;

    @ApiModelProperty("旗舰店项目设计师编号")
    @TableField("flagship_designer_number")
    private String flagshipDesignerNumber;

    @ApiModelProperty("旗舰店项目设计师名称")
    @TableField("flagship_designer_name")
    private String flagshipDesignerName;

    @ApiModelProperty("旗舰店项目设计状态")
    @TableField("flagship_designer_status")
    private Integer flagshipDesignerStatus;

    @ApiModelProperty("旗舰店项目设计完成时间")
    @TableField("flagship_designer_finish_time")
    private Integer flagshipDesignerFinishTime;

    @ApiModelProperty("筹备组申请人")
    @TableField("copyright_applicant")
    private String copyrightApplicant;

    @ApiModelProperty("筹备组申请人id")
    @TableField("copyright_applicant_id")
    private Long copyrightApplicantId;

    @ApiModelProperty("申请版权状态:0=未申请,1=申请中,2=申请成功,3=申请失败,4=重复")
    @TableField("copyright_applicant_status")
    private Integer copyrightApplicantStatus;

    @ApiModelProperty("申请版权时间")
    @TableField("copyright_applicant_time")
    private Integer copyrightApplicantTime;

    @ApiModelProperty("版权完成时间")
    @TableField("copyright_applicant_finish_time")
    private Integer copyrightApplicantFinishTime;

    @ApiModelProperty("版权号")
    @TableField("copyright_number")
    private String copyrightNumber;

    @ApiModelProperty("版权证书")
    @TableField("copyright_certificate")
    private String copyrightCertificate;

    @ApiModelProperty("申请公司")
    @TableField("apply_company")
    private String applyCompany;

    @ApiModelProperty("官网同步账号")
    @TableField("official_sync_account")
    private String officialSyncAccount;

    @ApiModelProperty("旗舰店同步账号")
    @TableField("flagship_sync_account")
    private String flagshipSyncAccount;

    @ApiModelProperty("US销售授权账号")
    @TableField("sale_account_us")
    private String saleAccountUs;

    @ApiModelProperty("US销售角色:0=请选择,1=Brand Representative,2=Reseller")
    @TableField("sale_role_us")
    private Integer saleRoleUs;

    @ApiModelProperty("UK销售授权账号")
    @TableField("sale_account_uk")
    private String saleAccountUk;

    @ApiModelProperty("UK销售角色:0=请选择,1=Brand Representative,2=Reseller")
    @TableField("sale_role_uk")
    private Integer saleRoleUk;

    @ApiModelProperty("版权名称")
    @TableField("copyright_name")
    private String copyrightName;

    @ApiModelProperty("US品牌丢失时间")
    @TableField("backstage_status_us_loss_time")
    private Integer backstageStatusUsLossTime;

    @ApiModelProperty("US品牌恢复时间")
    @TableField("backstage_status_us_restore_time")
    private Integer backstageStatusUsRestoreTime;

    @ApiModelProperty("Uk品牌丢失时间")
    @TableField("backstage_status_uk_loss_time")
    private Integer backstageStatusUkLossTime;

    @ApiModelProperty("Uk品牌恢复时间")
    @TableField("backstage_status_uk_restore_time")
    private Integer backstageStatusUkRestoreTime;

    @ApiModelProperty("UK序列号")
    @TableField("serial_number_uk")
    private String serialNumberUk;

    @ApiModelProperty("US是否可以做高级A+，0-否，1-是")
    @TableField("is_can_a_plus_senior_us")
    private Integer isCanAPlusSeniorUs;

    @ApiModelProperty("UK是否可以做高级A+，0-否，1-是")
    @TableField("is_can_a_plus_senior_uk")
    private Integer isCanAPlusSeniorUk;


}
