package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 对应inv 产品审核表
 * </p>
 *
 * @author guokunkun
 * @since 2025-01-02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("sync_product_audit")
@ApiModel(value = "SyncProductAudit对象", description = "对应inv 产品审核表")
public class SyncProductAudit implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("亚马逊账号")
    @TableField("`account`")
    private String account;

    @ApiModelProperty(" 旧sku")
    @TableField("old_sku")
    private String oldSku;

    @ApiModelProperty("产品sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("产品开发人员")
    @TableField("developer_num")
    private String developerNum;

    @ApiModelProperty("图片链接")
    @TableField("raw_pic_url")
    private String rawPicUrl;

    @ApiModelProperty("根据竞品标题中解析出来的asin")
    @TableField("competitor_asin")
    private String competitorAsin;

    @ApiModelProperty("产品类型")
    @TableField("product_type")
    private Integer productType;

    @ApiModelProperty("关联sku")
    @TableField("relative_sku")
    private String relativeSku;

    @ApiModelProperty("关联sku id")
    @TableField("relative_id")
    private String relativeId;

    @ApiModelProperty("变体主题")
    @TableField("variant_subject")
    private Integer variantSubject;

    @ApiModelProperty("变体个数")
    @TableField("variant_amount")
    private Integer variantAmount;

    @ApiModelProperty("创建时间")
    @TableField("create_at")
    private Integer createAt;

    @ApiModelProperty("修改时间")
    @TableField("update_at")
    private Integer updateAt;

    @ApiModelProperty("  节气,  1=>'常规产品',	        2=>'婚礼季',	        3=>'复活节',	        4=>'万圣节',	        5=>'感恩节',	        6=>'圣诞节',	//        7=>'黑色星期五(11月第四个周五)',	        8=>'母亲节',	        9=>'父亲节',	        10=>'开学季',	        11=>'毕业季',	        12=>'夏季产品',	        13=>'冬季产品',	        14=>'其他节气',	        15=>'春节',	        16=>'情人节',	        17=>'爱尔兰节',	        18=>'独立日'")
    @TableField("solar_term")
    private Integer solarTerm;

    @ApiModelProperty("是否组合变体，1是，0不是")
    @TableField("is_comb_variant")
    private Integer isCombVariant;

    @ApiModelProperty("组合父id")
    @TableField("comb_parent_id")
    private Integer combParentId;

    @ApiModelProperty("组合父sku")
    @TableField("comb_parent_sku")
    private String combParentSku;

    @ApiModelProperty("销售编号")
    @TableField("seller_num")
    private String sellerNum;

    @ApiModelProperty("中文简称")
    @TableField("short_title_ch")
    private String shortTitleCh;

    @ApiModelProperty("英文简称")
    @TableField("short_title_en")
    private String shortTitleEn;

    @ApiModelProperty("欧洲站sku")
    @TableField("eu_product_sku")
    private String euProductSku;

    @ApiModelProperty("开发标题")
    @TableField("developer_title")
    private String developerTitle;

    @ApiModelProperty("小图片链接")
    @TableField("small_pic_url")
    private String smallPicUrl;

    @ApiModelProperty("同步时间")
    @TableField("sync_time")
    private Integer syncTime;

    @ApiModelProperty("审核状态")
    @TableField("product_audit_status")
    private String productAuditStatus;

    @ApiModelProperty("是否只做简易视频 (0 1是 2否)")
    @TableField("is_make_simple_video")
    private Integer isMakeSimpleVideo;

    @ApiModelProperty("开发填写备注")
    @TableField("develop_remark")
    private String developRemark;

    @ApiModelProperty("产品等级")
    @TableField("product_level")
    private String productLevel;

    @ApiModelProperty("list_audit_time list审核时间")
    @TableField("list_audit_time")
    private Integer listAuditTime;

    @ApiModelProperty("商标风险")
    @TableField("trademark_risk")
    private String trademarkRisk;

    @ApiModelProperty("精简文案")
    @TableField("simple_wa")
    private String simpleWa;

    @ApiModelProperty("文案优化人员")
    @TableField("copywriting_optimization_user")
    private String copywritingOptimizationUser;

    @ApiModelProperty("品牌名")
    @TableField("brand_name")
    private String brandName;

    @ApiModelProperty("成本价")
    @TableField("cost_price")
    private BigDecimal costPrice;

    @ApiModelProperty("首批采购数量")
    @TableField("purchase_quantity")
    private Integer purchaseQuantity;

    @ApiModelProperty("是否潜力产品，0-否，1-是")
    @TableField("maintain_level")
    private Integer maintainLevel;

    @ApiModelProperty("销售填写备注")
    @TableField("sale_remark")
    private String saleRemark;

    @ApiModelProperty("US上传分类")
    @TableField("us_upload_type")
    private Integer usUploadType;

    @ApiModelProperty("us一级类目")
    @TableField("us_root_type")
    private String usRootType;

    @ApiModelProperty("商标类别")
    @TableField("register_type")
    private String registerType;

    @ApiModelProperty("是否鼓励政策")
    @TableField("is_cheer_policy")
    private Integer isCheerPolicy;

    @ApiModelProperty("专项类型")
    @TableField("special_type")
    private Integer specialType;

    @ApiModelProperty("供应商链接")
    @TableField("supplier_url")
    private String supplierUrl;

    @ApiModelProperty("审核时间")
    @TableField("audit_time")
    private Integer auditTime;

    @ApiModelProperty("审核备注")
    @TableField("audit_remark")
    private String auditRemark;

    @ApiModelProperty(value = "是否定制产品")
    private Integer isCustomProduct;

    public Integer getIsCustomProduct() {
        return isCustomProduct;
    }

    public void setIsCustomProduct(Integer isCustomProduct) {
        this.isCustomProduct = isCustomProduct;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getOldSku() {
        return oldSku;
    }

    public void setOldSku(String oldSku) {
        this.oldSku = oldSku;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getDeveloperNum() {
        return developerNum;
    }

    public void setDeveloperNum(String developerNum) {
        this.developerNum = developerNum;
    }

    public String getRawPicUrl() {
        return rawPicUrl;
    }

    public void setRawPicUrl(String rawPicUrl) {
        this.rawPicUrl = rawPicUrl;
    }

    public String getCompetitorAsin() {
        return competitorAsin;
    }

    public void setCompetitorAsin(String competitorAsin) {
        this.competitorAsin = competitorAsin;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public String getRelativeSku() {
        return relativeSku;
    }

    public void setRelativeSku(String relativeSku) {
        this.relativeSku = relativeSku;
    }

    public String getRelativeId() {
        return relativeId;
    }

    public void setRelativeId(String relativeId) {
        this.relativeId = relativeId;
    }

    public Integer getVariantSubject() {
        return variantSubject;
    }

    public void setVariantSubject(Integer variantSubject) {
        this.variantSubject = variantSubject;
    }

    public Integer getVariantAmount() {
        return variantAmount;
    }

    public void setVariantAmount(Integer variantAmount) {
        this.variantAmount = variantAmount;
    }

    public Integer getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Integer createAt) {
        this.createAt = createAt;
    }

    public Integer getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Integer updateAt) {
        this.updateAt = updateAt;
    }

    public Integer getSolarTerm() {
        return solarTerm;
    }

    public void setSolarTerm(Integer solarTerm) {
        this.solarTerm = solarTerm;
    }

    public Integer getIsCombVariant() {
        return isCombVariant;
    }

    public void setIsCombVariant(Integer isCombVariant) {
        this.isCombVariant = isCombVariant;
    }

    public Integer getCombParentId() {
        return combParentId;
    }

    public void setCombParentId(Integer combParentId) {
        this.combParentId = combParentId;
    }

    public String getCombParentSku() {
        return combParentSku;
    }

    public void setCombParentSku(String combParentSku) {
        this.combParentSku = combParentSku;
    }

    public String getSellerNum() {
        return sellerNum;
    }

    public void setSellerNum(String sellerNum) {
        this.sellerNum = sellerNum;
    }

    public String getShortTitleCh() {
        return shortTitleCh;
    }

    public void setShortTitleCh(String shortTitleCh) {
        this.shortTitleCh = shortTitleCh;
    }

    public String getShortTitleEn() {
        return shortTitleEn;
    }

    public void setShortTitleEn(String shortTitleEn) {
        this.shortTitleEn = shortTitleEn;
    }

    public String getEuProductSku() {
        return euProductSku;
    }

    public void setEuProductSku(String euProductSku) {
        this.euProductSku = euProductSku;
    }

    public String getDeveloperTitle() {
        return developerTitle;
    }

    public void setDeveloperTitle(String developerTitle) {
        this.developerTitle = developerTitle;
    }

    public String getSmallPicUrl() {
        return smallPicUrl;
    }

    public void setSmallPicUrl(String smallPicUrl) {
        this.smallPicUrl = smallPicUrl;
    }

    public Integer getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(Integer syncTime) {
        this.syncTime = syncTime;
    }

    public String getProductAuditStatus() {
        return productAuditStatus;
    }

    public void setProductAuditStatus(String productAuditStatus) {
        this.productAuditStatus = productAuditStatus;
    }

    public Integer getIsMakeSimpleVideo() {
        return isMakeSimpleVideo;
    }

    public void setIsMakeSimpleVideo(Integer isMakeSimpleVideo) {
        this.isMakeSimpleVideo = isMakeSimpleVideo;
    }

    public String getDevelopRemark() {
        return developRemark;
    }

    public void setDevelopRemark(String developRemark) {
        this.developRemark = developRemark;
    }

    public String getProductLevel() {
        return productLevel;
    }

    public void setProductLevel(String productLevel) {
        this.productLevel = productLevel;
    }

    public Integer getListAuditTime() {
        return listAuditTime;
    }

    public void setListAuditTime(Integer listAuditTime) {
        this.listAuditTime = listAuditTime;
    }

    public String getTrademarkRisk() {
        return trademarkRisk;
    }

    public void setTrademarkRisk(String trademarkRisk) {
        this.trademarkRisk = trademarkRisk;
    }

    public String getSimpleWa() {
        return simpleWa;
    }

    public void setSimpleWa(String simpleWa) {
        this.simpleWa = simpleWa;
    }

    public String getCopywritingOptimizationUser() {
        return copywritingOptimizationUser;
    }

    public void setCopywritingOptimizationUser(String copywritingOptimizationUser) {
        this.copywritingOptimizationUser = copywritingOptimizationUser;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getPurchaseQuantity() {
        return purchaseQuantity;
    }

    public void setPurchaseQuantity(Integer purchaseQuantity) {
        this.purchaseQuantity = purchaseQuantity;
    }

    public Integer getMaintainLevel() {
        return maintainLevel;
    }

    public void setMaintainLevel(Integer maintainLevel) {
        this.maintainLevel = maintainLevel;
    }

    public String getSaleRemark() {
        return saleRemark;
    }

    public void setSaleRemark(String saleRemark) {
        this.saleRemark = saleRemark;
    }

    public Integer getUsUploadType() {
        return usUploadType;
    }

    public void setUsUploadType(Integer usUploadType) {
        this.usUploadType = usUploadType;
    }

    public String getUsRootType() {
        return usRootType;
    }

    public void setUsRootType(String usRootType) {
        this.usRootType = usRootType;
    }

    public String getRegisterType() {
        return registerType;
    }

    public void setRegisterType(String registerType) {
        this.registerType = registerType;
    }

    public Integer getIsCheerPolicy() {
        return isCheerPolicy;
    }

    public void setIsCheerPolicy(Integer isCheerPolicy) {
        this.isCheerPolicy = isCheerPolicy;
    }

    public Integer getSpecialType() {
        return specialType;
    }

    public void setSpecialType(Integer specialType) {
        this.specialType = specialType;
    }

    public String getSupplierUrl() {
        return supplierUrl;
    }

    public void setSupplierUrl(String supplierUrl) {
        this.supplierUrl = supplierUrl;
    }

    public Integer getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Integer auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditRemark() {
        return auditRemark;
    }

    public void setAuditRemark(String auditRemark) {
        this.auditRemark = auditRemark;
    }
}
