package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 开发-平面设计任务自动分配-同步sku表
 * </p>
 *
 * @author guokunkun
 * @since 2025-10-14
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_developer_plane_design_assignment_sku")
@ApiModel(value = "VisualDeveloperPlaneDesignAssignmentSku对象", description = "开发-平面设计任务自动分配-同步sku表")
public class VisualDeveloperPlaneDesignAssignmentSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("主任务id")
    @TableField("main_id")
    private Long mainId;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @TableField("ctr")
    private BigDecimal ctr;


}
