package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉设计协同系统-视频策划
 * </p>
 *
 * @author guokunkun
 * @since 2024-12-25
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_video_plan")
@ApiModel(value = "VisualVideoPlan对象", description = "视觉设计协同系统-视频策划")
public class VisualVideoPlan implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("标题")
    @TableField("title")
    private String title;

    @ApiModelProperty("执行者")
    @TableField("executor_name")
    private String executorName;

    @ApiModelProperty("执行者编号")
    @TableField("executor_number")
    private String executorNumber;

    @ApiModelProperty("状态，0-未完成，1-进行中，2-完成,3-不需要处理")
    @TableField("`status`")
    private Integer status;

    @ApiModelProperty("状态为不需要处理时的原因：1-过季，2-断货无样品，3-开发要求不做，4-其他原因")
    @TableField("no_handle_reason")
    private Integer noHandleReason;

    @ApiModelProperty("是否有样品,0-否，1-是")
    @TableField("is_have_sample")
    private Integer isHaveSample;

    @ApiModelProperty("有样品时间(对应invt的delivery_time)")
    @TableField("have_sample_time")
    private Integer haveSampleTime;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("优先级")
    @TableField("priority")
    private String priority;

    @ApiModelProperty("标签id(visual_design_tag的id)")
    @TableField("vdt_id")
    private String vdtId;

    @ApiModelProperty("风险检测")
    @TableField("risk_check_area")
    private String riskCheckArea;

    @ApiModelProperty("风险检测状态,0-否，1-是[对应inv的is_submit]")
    @TableField("risk_check_status")
    private Integer riskCheckStatus;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("文件url")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("站点")
    @TableField("site")
    private String site;

    @ApiModelProperty("地区")
    @TableField("region")
    private String region;

    @ApiModelProperty("是否删除，0-否1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("完成时间")
    @TableField("finish_time")
    private Integer finishTime;

    @ApiModelProperty("暂停时间")
    @TableField("pause_time")
    private Integer pauseTime;

    @ApiModelProperty("visual_communication_design表id")
    @TableField("communication_design_id")
    private Long communicationDesignId;

    @ApiModelProperty("是否需要翻译")
    @TableField("is_translate")
    private Integer isTranslate;

    @ApiModelProperty("翻译语种")
    @TableField("languages")
    private String languages;

    @ApiModelProperty("首个发起申请的sku")
    @TableField("apply_sku")
    private String applySku;

    @ApiModelProperty("样品状态::1-正，2-次")
    @TableField("sample_status")
    private Integer sampleStatus;

    @ApiModelProperty("样品备注")
    @TableField("sample_status_remark")
    private String sampleStatusRemark;

    @ApiModelProperty("长视频地址")
    @TableField("long_video_url")
    private String longVideoUrl;

    @ApiModelProperty("短视频地址")
    @TableField("short_video_url")
    private String shortVideoUrl;

    @ApiModelProperty("封面图")
    @TableField("cover_image_url")
    private String coverImageUrl;

    @ApiModelProperty("样品全部到货时间")
    @TableField("sample_arrive_time")
    private Integer sampleArriveTime;

    @ApiModelProperty("前台是否有视频")
    @TableField("is_video_in_amazon")
    private Integer isVideoInAmazon;

    @ApiModelProperty("是否为精品产品，0-否，1-是")
    @TableField("is_boutique_product")
    private Integer isBoutiqueProduct;

    @ApiModelProperty("权重")
    @TableField("weight")
    private BigDecimal weight;

    @ApiModelProperty("是否走流程，0-否，1-是")
    @TableField("follow_the_process")
    private Integer followTheProcess;

    @ApiModelProperty("是否是销量评优，0-否，1-是")
    @TableField("sale_appraising_flag")
    private Integer saleAppraisingFlag;

    @ApiModelProperty("取样人员")
    @TableField("take_sample_person")
    private String takeSamplePerson;

    @ApiModelProperty("摄影是否取样，0-否，1-是")
    @TableField("is_give_sample")
    private Integer isGiveSample;

    @ApiModelProperty("取样时间，摄影是否取样为是时，需要有值")
    @TableField("give_sample_time")
    private Integer giveSampleTime;

    @ApiModelProperty("视频是否侵权：0-否，1-是")
    @TableField("video_is_tort")
    private Integer videoIsTort;

    @ApiModelProperty("视频侵权意见")
    @TableField("video_tort_reason")
    private String videoTortReason;


}
