package cn.kk.spring_simple_operation.service.impl;

import cn.kk.spring_simple_operation.entity.VideoProduct;
import cn.kk.spring_simple_operation.mapper.VideoProductMapper;
import cn.kk.spring_simple_operation.model.dto.SkuSiteDTO;
import cn.kk.spring_simple_operation.service.VideoProductService;
import cn.kk.spring_simple_operation.service.VisualDesignLogService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 视频产品 服务实现类
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-27
 */
@Service
public class VideoProductServiceImpl extends ServiceImpl<VideoProductMapper, VideoProduct> implements VideoProductService {

	@Resource
	private VisualDesignLogService visualDesignLogService;

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void setUploadStatusIsDeleted(List<SkuSiteDTO> list) {
		List<VideoProduct> listVideoProduct = baseMapper.getListBySkuAndSite(list);
		List<Long> ids = listVideoProduct.stream()
				.filter(videoProduct -> videoProduct.getVideoIsUploadBackstage() != 5)
				.map(VideoProduct::getId)
				.collect(Collectors.toList());

		update(Wrappers.<VideoProduct>lambdaUpdate().in(VideoProduct::getId, ids)
				.set(VideoProduct::getVideoIsUploadBackstage, 5)
		);
		visualDesignLogService.addBatchLog("video_product", "根据文件将sku和站点的视频上传后台状态设置为已删除", ids);
	}
}
