package cn.kk.spring_simple_operation.service.impl;

import cn.kk.spring_simple_operation.entity.VisualDesignLog;
import cn.kk.spring_simple_operation.mapper.VisualDesignLogMapper;
import cn.kk.spring_simple_operation.service.VisualDesignLogService;
import cn.kk.spring_simple_operation.utils.DateUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 视觉操作日志 服务实现类
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-19
 */
@Service
public class VisualDesignLogServiceImpl extends ServiceImpl<VisualDesignLogMapper, VisualDesignLog> implements VisualDesignLogService {

	@Override
	public void addLog(String operationKey, String operationContent, Long relationId) {
		if(StringUtils.isEmpty(operationContent)){
			return;
		}
		VisualDesignLog visualDesignLog = new VisualDesignLog();
		visualDesignLog.setId(IdWorker.getId());
		visualDesignLog.setOperationKey(operationKey);
		visualDesignLog.setCreateId(0);
		visualDesignLog.setCreateName("系统");
		visualDesignLog.setOperationContent(operationContent);
		visualDesignLog.setRelationId(relationId);
		visualDesignLog.setFileUrl("");
		visualDesignLog.setCreateTime(DateUtils.getCurrentTimeSecond());
		visualDesignLog.setOperationType("");
		this.save(visualDesignLog);
	}

	@Override
	public void addBatchLog(String operationKey, String operationContent, List<Long> relationIdList) {
		if(StringUtils.isEmpty(operationContent)){
			return;
		}
		List<VisualDesignLog> logs = relationIdList.stream().map(relationId -> {
			VisualDesignLog visualDesignLog = new VisualDesignLog();
			visualDesignLog.setId(IdWorker.getId());
			visualDesignLog.setOperationKey(operationKey);
			visualDesignLog.setCreateId(0);
			visualDesignLog.setCreateName("系统");
			visualDesignLog.setOperationContent(operationContent);
			visualDesignLog.setRelationId(relationId);
			visualDesignLog.setFileUrl("");
			visualDesignLog.setCreateTime(DateUtils.getCurrentTimeSecond());
			visualDesignLog.setOperationType("");
			return visualDesignLog;
		}).collect(Collectors.toList());
		this.saveBatch(logs);
	}
}
