package cn.kk.spring_simple_operation.service.impl;

import cn.kk.spring_simple_operation.entity.VisualDesigner;
import cn.kk.spring_simple_operation.entity.VisualPhotographerAPlus;
import cn.kk.spring_simple_operation.mapper.VisualDesignerMapper;
import cn.kk.spring_simple_operation.mapper.VisualPhotographerAPlusMapper;
import cn.kk.spring_simple_operation.service.VisualDesignLogService;
import cn.kk.spring_simple_operation.service.VisualPhotographerAPlusService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * <p>
 * 视觉设计协同系统-摄影A+ 服务实现类
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-19
 */
@Slf4j
@Service
public class VisualPhotographerAPlusServiceImpl extends ServiceImpl<VisualPhotographerAPlusMapper, VisualPhotographerAPlus> implements VisualPhotographerAPlusService {

	@Resource
	private VisualDesignerMapper   visualDesignerMapper;
	@Resource
	private VisualDesignLogService visualDesignLogService;


	@Override
	public void brushDataForExecutor() {
		AtomicInteger count = new AtomicInteger(0);
		List<VisualPhotographerAPlus> list = baseMapper.listNoExecutor();
		list.forEach(item -> {
			VisualDesigner visualDesigner = visualDesignerMapper.getDesignerByPlan(item.getExecutorNumber());
			if (Objects.isNull(visualDesigner)) {
				return;
			}
			item.setExecutorName(visualDesigner.getUserName());
			item.setExecutorNumber(visualDesigner.getVisualNumber());
			baseMapper.updateById(item);
			visualDesignLogService.addLog("visual_photographer_a_plus", "分配执行人为：" + visualDesigner.getUserName(), item.getId());
			count.incrementAndGet();
		});
		log.info("brushDataForExecutor success, count: {}, all: {}", count.get(), list.size());
	}
}
