package cn.kk.spring_simple_operation;

import cn.kk.spring_simple_operation.entity.VisualDeveloperPlaneDesignAssignment;
import cn.kk.spring_simple_operation.entity.VisualDeveloperPlaneDesignAssignmentSku;
import cn.kk.spring_simple_operation.mapper.PhotoProgressMapper;
import cn.kk.spring_simple_operation.model.dto.BrandAccountDto;
import cn.kk.spring_simple_operation.model.dto.SkuPeopleNameDto;
import cn.kk.spring_simple_operation.model.dto.SkuSiteDTO;
import cn.kk.spring_simple_operation.model.vo.PhotoSkuInfo;
import cn.kk.spring_simple_operation.model.vo.PublishInfoVo;
import cn.kk.spring_simple_operation.service.*;
import cn.kk.spring_simple_operation.utils.DateUtils;
import cn.kk.spring_simple_operation.utils.ExcelUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author kk
 * @date 2025/2/19
 */
@SpringBootTest
public class ApplicationTest {

	@Resource
	private VisualPhotographerAPlusService visualPhotographerAPlusService;

	@Resource
	private VideoProductService videoProductService;

	@Resource
	private PhotoProgressService photoProgressService;

	@Resource
	private PhotoProgressMapper photoProgressMapper;

	@Resource
	private APlusProductService aPlusProductService;

	@Resource
	private BrandRecordToolService brandRecordToolService;

	@Resource
	private VisualDeveloperPlaneDesignAssignmentSkuService visualDeveloperPlaneDesignAssignmentSkuService;

	@Resource
	private VisualDeveloperPlaneDesignAssignmentService visualDeveloperPlaneDesignAssignmentService;

	@Resource
	private VisualDesignLogService visualDesignLogService;

	@Resource
	private TransactionTemplate transactionTemplate;

	@Test
	void contextLoads() throws Exception {
		//visualPhotographerAPlusService.brushDataForExecutor();

		//setUploadStatusIsDeleted();

		//setAPlusProductUploadInfo();

		//updateBrandId();

		//updateBrandTransparencyPlan();

		//getVideoSkuArea();

		//brushSimpleVideoData();

		//exportAPlusPublishData();

		//brushSimpleVideoData_2();

		brushYf2PlaneDesignAssignmentTime();
	}

	private void brushYf2PlaneDesignAssignmentTime() throws Exception {
		File file = new File("2025-10-13_v6tg_研发二部B组-修图安排.xlsx");
		ExcelUtil<SkuSiteDTO> util = new ExcelUtil<SkuSiteDTO>(SkuSiteDTO.class);
		List<SkuSiteDTO> list = util.importExcel("研发二部", Files.newInputStream(file.toPath()));
		Map<String, Integer> skuMap = new HashMap<>();
		list.forEach(t -> {
			long time = Long.parseLong(t.getDataStr()) / 1000L;
			skuMap.put(t.getSku(), (int) time);
		});
		Map<Long, List<VisualDeveloperPlaneDesignAssignmentSku>> idMap = visualDeveloperPlaneDesignAssignmentSkuService.list(Wrappers.<VisualDeveloperPlaneDesignAssignmentSku>lambdaQuery()
				.in(VisualDeveloperPlaneDesignAssignmentSku::getSku, skuMap.keySet())
				.select(VisualDeveloperPlaneDesignAssignmentSku::getMainId, VisualDeveloperPlaneDesignAssignmentSku::getSku)
		).stream().collect(Collectors.groupingBy(VisualDeveloperPlaneDesignAssignmentSku::getMainId));

		idMap.forEach((id, skuList) -> {
			VisualDeveloperPlaneDesignAssignment one = visualDeveloperPlaneDesignAssignmentService.getOne(Wrappers.<VisualDeveloperPlaneDesignAssignment>lambdaQuery()
					.eq(VisualDeveloperPlaneDesignAssignment::getId, id).select(VisualDeveloperPlaneDesignAssignment::getCreateTime, VisualDeveloperPlaneDesignAssignment::getSku));
			if (Objects.isNull(one)) return;
			Optional<Integer> first = skuList.stream().map(skuMap::get).filter(Objects::nonNull).findFirst();
			if (!first.isPresent()) return;
			Integer time = first.get();
			VisualDeveloperPlaneDesignAssignment update = new VisualDeveloperPlaneDesignAssignment();
			update.setId(id);
			update.setCreateTime(time);
			transactionTemplate.execute(status -> {
				visualDeveloperPlaneDesignAssignmentService.updateById(update);
				visualDesignLogService.addLog("visual_developer_plane_design_assignment",
						String.format("开发提交时间由%s调整为%s", DateUtils.format10YMD(one.getCreateTime()), DateUtils.format10YMD(time)),
						id
				);
				return true;
			});
		});
	}

	//private void brushSimpleVideoData_2() throws Exception {
	//	File file = new File("2025-06-30_vkai_2025老产品补拍简易视频进度.xlsx");
	//	ExcelUtil<SkuSiteDTO> util = new ExcelUtil<SkuSiteDTO>(SkuSiteDTO.class);
	//	List<SkuSiteDTO> list = util.importExcel("指定人员", Files.newInputStream(file.toPath()));
	//	photoProgressService.brushSimpleVideoDataPeople(list);
	//	list = util.importExcel("前台有视频的 刷成简易视频不需要处理", Files.newInputStream(file.toPath()));
	//	photoProgressService.brushSimpleVideoDataStatus(list);
	//}

	//private void exportAPlusPublishData() throws Exception {
	//	List<PublishInfoVo> publishInfoVos = aPlusProductService.exportAPlusPublishData();
	//	ExcelUtil<PublishInfoVo> util = new ExcelUtil<>(PublishInfoVo.class);
	//	util.exportExcelFile(publishInfoVos, "运营导数据-20250618.xlsx");
	//}

	//private void brushSimpleVideoData() {
	//	photoProgressService.brushSimpleVideoData();
	//}

	//private void setUploadStatusIsDeleted() throws Exception {
	//	File file = new File("已删除页面直接调整视频状态.xlsx");
	//	ExcelUtil<SkuSiteDTO> util = new ExcelUtil<SkuSiteDTO>(SkuSiteDTO.class);
	//	List<SkuSiteDTO> list = util.importExcel("精细视频", Files.newInputStream(file.toPath()));
	//	videoProductService.setUploadStatusIsDeleted(list);
	//	list = util.importExcel("简易视频", Files.newInputStream(file.toPath()));
	//	photoProgressService.setUploadStatusIsDeleted(list);
	//}

	//private void setAPlusProductUploadInfo() throws Exception {
	//	File file = new File("简版A+ AB测试.xlsx");
	//	ExcelUtil<SkuPeopleNameDto> util = new ExcelUtil<>(SkuPeopleNameDto.class);
	//	List<SkuPeopleNameDto> list = util.importExcel(Files.newInputStream(file.toPath()));
	//	aPlusProductService.setAPlusProductUploadInfo(list);
	//}


	//private void updateBrandId() throws Exception {
	//	File file = new File("2025-04-01_vpq0_品牌Brand ID核对.xlsx");
	//	ExcelUtil<BrandAccountDto> util = new ExcelUtil<>(BrandAccountDto.class);
	//	List<BrandAccountDto> list = util.importExcel(Files.newInputStream(file.toPath()));
	//	brandRecordToolService.updateBrandId(list);
	//}


	//private void updateBrandTransparencyPlan() throws Exception {
	//		File file = new File("2025-04-16_vlrd_高首批新品匹配透明计划账号.xlsx");
	//		ExcelUtil<BrandAccountDto> util = new ExcelUtil<>(BrandAccountDto.class);
	//		List<BrandAccountDto> list = util.importExcel(Files.newInputStream(file.toPath()));
	//
	//		list.forEach(dto -> {
	//			System.out.printf("update brand_record_tool set is_transparency_plan = 1 where record_brand = '%s' and account = '%s' and is_delete = 0;\n", dto.getBrand(), dto.getAccount());
	//		});
	//}


	//private void getVideoSkuArea() {
	//
	//	photoProgressService.getVideoSkuArea();
	//}


}
