package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 各部门分组表
 * </p>
 *
 * @author guokunkun
 * @since 2025-05-26
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("dept_group")
@ApiModel(value = "DeptGroup对象", description = "各部门分组表")
public class DeptGroup implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("父组Id")
    @TableField("parent_id")
    private Integer parentId;

    @ApiModelProperty("归属的顶级部门如：开发、摄影等")
    @TableField("module")
    private String module;

    @ApiModelProperty("部门/组名称")
    @TableField("group_name")
    private String groupName;

    @ApiModelProperty("部门/组简称(代表组路径)")
    @TableField("group_num")
    private String groupNum;

    @ApiModelProperty("部门/组职位")
    @TableField("position")
    private String position;

    @ApiModelProperty("是否是叶子节点")
    @TableField("is_leaf")
    private Integer isLeaf;

    @ApiModelProperty("节点全路径")
    @TableField("node_path")
    private String nodePath;

    @ApiModelProperty("路径全名")
    @TableField("full_name")
    private String fullName;


}
