package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * sku销量详情
 * </p>
 *
 * @author guokunkun
 * @since 2024-12-25
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("sync_product_publish")
@ApiModel(value = "SyncProductPublish对象", description = "sku销量详情")
public class SyncProductPublish implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("产品id[暂无，可能考虑去掉]")
    @TableField("product_id")
    private Long productId;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("账号")
    @TableField("`account`")
    private String account;

    @ApiModelProperty("站点")
    @TableField("site")
    private String site;

    @ApiModelProperty("3天销量")
    @TableField("three_day_sales")
    private Integer threeDaySales;

    @ApiModelProperty("7天销量")
    @TableField("seven_day_sales")
    private Integer sevenDaySales;

    @ApiModelProperty("30天销量欧洲")
    @TableField("thirty_day_gbsales")
    private Integer thirtyDayGbsales;

    @ApiModelProperty("30天销量")
    @TableField("thirty_day_sales")
    private Integer thirtyDaySales;

    @ApiModelProperty("30天退货数")
    @TableField("thirty_day_return")
    private Integer thirtyDayReturn;

    @TableField("thirty_day_return_rate")
    private BigDecimal thirtyDayReturnRate;

    @ApiModelProperty("30天退货不可再售总数")
    @TableField("thirty_day_return_no_resale")
    private Integer thirtyDayReturnNoResale;

    @TableField("thirty_day_return_rate_no_resale")
    private BigDecimal thirtyDayReturnRateNoResale;

    @ApiModelProperty("90天销量")
    @TableField("ninety_day_sales")
    private Integer ninetyDaySales;

    @ApiModelProperty("90天退货数")
    @TableField("ninety_day_return")
    private Integer ninetyDayReturn;

    @TableField("ninety_day_return_rate")
    private BigDecimal ninetyDayReturnRate;

    @ApiModelProperty("90天退货不可再售总数")
    @TableField("ninety_day_return_no_resale")
    private Integer ninetyDayReturnNoResale;

    @TableField("ninety_day_return_rate_no_resale")
    private BigDecimal ninetyDayReturnRateNoResale;

    @ApiModelProperty("总销量")
    @TableField("sum_sales")
    private Integer sumSales;

    @ApiModelProperty("总销量退货数")
    @TableField("sum_sales_return")
    private Integer sumSalesReturn;

    @TableField("sum_sales_return_rate")
    private BigDecimal sumSalesReturnRate;

    @ApiModelProperty("总销量退货不可再售总数")
    @TableField("sum_sales_return_no_resale")
    private Integer sumSalesReturnNoResale;

    @TableField("sum_sales_return_rate_no_resale")
    private BigDecimal sumSalesReturnRateNoResale;

    @ApiModelProperty("关联key值，asin/upc")
    @TableField("relation_key")
    private String relationKey;

    @ApiModelProperty("开售时间")
    @TableField("sale_time")
    private Integer saleTime;

    @ApiModelProperty("平台上的产品图片")
    @TableField("plat_img_url")
    private String platImgUrl;

    @ApiModelProperty("销售状态")
    @TableField("sale_status")
    private String saleStatus;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("父asin")
    @TableField("parent_asin")
    private String parentAsin;

    @ApiModelProperty("创建日期(amazon产品页面)")
    @TableField("open_date")
    private Integer openDate;

    @ApiModelProperty("销售编号")
    @TableField("seller_num")
    private String sellerNum;

    @ApiModelProperty("（已弃用)")
    @TableField("rating")
    private BigDecimal rating;

    @TableField("lowest_price")
    private BigDecimal lowestPrice;

    @ApiModelProperty("产品成功标志，0代表观察期，1代表成功产品，2代表不成功产品")
    @TableField("success_flag")
    private Integer successFlag;

    @ApiModelProperty("品牌名(product_publish_keepa表 （已弃用))")
    @TableField("brand_name")
    private String brandName;

    @ApiModelProperty("跟卖原SKU(product_publish_ext表)")
    @TableField("raw_sku")
    private String rawSku;

    @ApiModelProperty("节气")
    @TableField("solar_term")
    private Integer solarTerm;

    @ApiModelProperty("同步时间")
    @TableField("sync_time")
    private Integer syncTime;

    @ApiModelProperty("原开售时间（对应inv origin_fuldate）")
    @TableField("raw_sale_time")
    private Integer rawSaleTime;

    @ApiModelProperty("评论数（已弃用)")
    @TableField("reviews")
    private Integer reviews;

    @TableField("ctr")
    private BigDecimal ctr;

    @ApiModelProperty("产品名称")
    @TableField("product_name")
    private String productName;

    @ApiModelProperty("tiktok销售用户id")
    @TableField("tk_sale_user_id")
    private Integer tkSaleUserId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public Integer getThreeDaySales() {
        return threeDaySales;
    }

    public void setThreeDaySales(Integer threeDaySales) {
        this.threeDaySales = threeDaySales;
    }

    public Integer getSevenDaySales() {
        return sevenDaySales;
    }

    public void setSevenDaySales(Integer sevenDaySales) {
        this.sevenDaySales = sevenDaySales;
    }

    public Integer getThirtyDayGbsales() {
        return thirtyDayGbsales;
    }

    public void setThirtyDayGbsales(Integer thirtyDayGbsales) {
        this.thirtyDayGbsales = thirtyDayGbsales;
    }

    public Integer getThirtyDaySales() {
        return thirtyDaySales;
    }

    public void setThirtyDaySales(Integer thirtyDaySales) {
        this.thirtyDaySales = thirtyDaySales;
    }

    public Integer getThirtyDayReturn() {
        return thirtyDayReturn;
    }

    public void setThirtyDayReturn(Integer thirtyDayReturn) {
        this.thirtyDayReturn = thirtyDayReturn;
    }

    public BigDecimal getThirtyDayReturnRate() {
        return thirtyDayReturnRate;
    }

    public void setThirtyDayReturnRate(BigDecimal thirtyDayReturnRate) {
        this.thirtyDayReturnRate = thirtyDayReturnRate;
    }

    public Integer getThirtyDayReturnNoResale() {
        return thirtyDayReturnNoResale;
    }

    public void setThirtyDayReturnNoResale(Integer thirtyDayReturnNoResale) {
        this.thirtyDayReturnNoResale = thirtyDayReturnNoResale;
    }

    public BigDecimal getThirtyDayReturnRateNoResale() {
        return thirtyDayReturnRateNoResale;
    }

    public void setThirtyDayReturnRateNoResale(BigDecimal thirtyDayReturnRateNoResale) {
        this.thirtyDayReturnRateNoResale = thirtyDayReturnRateNoResale;
    }

    public Integer getNinetyDaySales() {
        return ninetyDaySales;
    }

    public void setNinetyDaySales(Integer ninetyDaySales) {
        this.ninetyDaySales = ninetyDaySales;
    }

    public Integer getNinetyDayReturn() {
        return ninetyDayReturn;
    }

    public void setNinetyDayReturn(Integer ninetyDayReturn) {
        this.ninetyDayReturn = ninetyDayReturn;
    }

    public BigDecimal getNinetyDayReturnRate() {
        return ninetyDayReturnRate;
    }

    public void setNinetyDayReturnRate(BigDecimal ninetyDayReturnRate) {
        this.ninetyDayReturnRate = ninetyDayReturnRate;
    }

    public Integer getNinetyDayReturnNoResale() {
        return ninetyDayReturnNoResale;
    }

    public void setNinetyDayReturnNoResale(Integer ninetyDayReturnNoResale) {
        this.ninetyDayReturnNoResale = ninetyDayReturnNoResale;
    }

    public BigDecimal getNinetyDayReturnRateNoResale() {
        return ninetyDayReturnRateNoResale;
    }

    public void setNinetyDayReturnRateNoResale(BigDecimal ninetyDayReturnRateNoResale) {
        this.ninetyDayReturnRateNoResale = ninetyDayReturnRateNoResale;
    }

    public Integer getSumSales() {
        return sumSales;
    }

    public void setSumSales(Integer sumSales) {
        this.sumSales = sumSales;
    }

    public Integer getSumSalesReturn() {
        return sumSalesReturn;
    }

    public void setSumSalesReturn(Integer sumSalesReturn) {
        this.sumSalesReturn = sumSalesReturn;
    }

    public BigDecimal getSumSalesReturnRate() {
        return sumSalesReturnRate;
    }

    public void setSumSalesReturnRate(BigDecimal sumSalesReturnRate) {
        this.sumSalesReturnRate = sumSalesReturnRate;
    }

    public Integer getSumSalesReturnNoResale() {
        return sumSalesReturnNoResale;
    }

    public void setSumSalesReturnNoResale(Integer sumSalesReturnNoResale) {
        this.sumSalesReturnNoResale = sumSalesReturnNoResale;
    }

    public BigDecimal getSumSalesReturnRateNoResale() {
        return sumSalesReturnRateNoResale;
    }

    public void setSumSalesReturnRateNoResale(BigDecimal sumSalesReturnRateNoResale) {
        this.sumSalesReturnRateNoResale = sumSalesReturnRateNoResale;
    }

    public String getRelationKey() {
        return relationKey;
    }

    public void setRelationKey(String relationKey) {
        this.relationKey = relationKey;
    }

    public Integer getSaleTime() {
        return saleTime;
    }

    public void setSaleTime(Integer saleTime) {
        this.saleTime = saleTime;
    }

    public String getPlatImgUrl() {
        return platImgUrl;
    }

    public void setPlatImgUrl(String platImgUrl) {
        this.platImgUrl = platImgUrl;
    }

    public String getSaleStatus() {
        return saleStatus;
    }

    public void setSaleStatus(String saleStatus) {
        this.saleStatus = saleStatus;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getParentAsin() {
        return parentAsin;
    }

    public void setParentAsin(String parentAsin) {
        this.parentAsin = parentAsin;
    }

    public Integer getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Integer openDate) {
        this.openDate = openDate;
    }

    public String getSellerNum() {
        return sellerNum;
    }

    public void setSellerNum(String sellerNum) {
        this.sellerNum = sellerNum;
    }

    public BigDecimal getRating() {
        return rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public BigDecimal getLowestPrice() {
        return lowestPrice;
    }

    public void setLowestPrice(BigDecimal lowestPrice) {
        this.lowestPrice = lowestPrice;
    }

    public Integer getSuccessFlag() {
        return successFlag;
    }

    public void setSuccessFlag(Integer successFlag) {
        this.successFlag = successFlag;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getRawSku() {
        return rawSku;
    }

    public void setRawSku(String rawSku) {
        this.rawSku = rawSku;
    }

    public Integer getSolarTerm() {
        return solarTerm;
    }

    public void setSolarTerm(Integer solarTerm) {
        this.solarTerm = solarTerm;
    }

    public Integer getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(Integer syncTime) {
        this.syncTime = syncTime;
    }

    public Integer getRawSaleTime() {
        return rawSaleTime;
    }

    public void setRawSaleTime(Integer rawSaleTime) {
        this.rawSaleTime = rawSaleTime;
    }

    public Integer getReviews() {
        return reviews;
    }

    public void setReviews(Integer reviews) {
        this.reviews = reviews;
    }

    public BigDecimal getCtr() {
        return ctr;
    }

    public void setCtr(BigDecimal ctr) {
        this.ctr = ctr;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Integer getTkSaleUserId() {
        return tkSaleUserId;
    }

    public void setTkSaleUserId(Integer tkSaleUserId) {
        this.tkSaleUserId = tkSaleUserId;
    }
}
