package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视频产品
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-27
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("video_product")
@ApiModel(value = "VideoProduct对象", description = "视频产品")
public class VideoProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("站点")
    @TableField("site")
    private String site;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("关联sku")
    @TableField("relation_sku")
    private String relationSku;

    @ApiModelProperty("关联sku站点")
    @TableField("relation_sku_site")
    private String relationSkuSite;

    @ApiModelProperty("添加时备注")
    @TableField("add_remark")
    private String addRemark;

    @ApiModelProperty("视频等级")
    @TableField("video_level")
    private String videoLevel;

    @ApiModelProperty("是否共享视频,0-否，1-是")
    @TableField("is_share_video")
    private Integer isShareVideo;

    @ApiModelProperty("视频上传后台状态,0-默认值，1-未完成，2-完成，3-不需要处理")
    @TableField("video_is_upload_backstage")
    private Integer videoIsUploadBackstage;

    @ApiModelProperty("视频上传备注")
    @TableField("video_upload_remark")
    private String videoUploadRemark;

    @ApiModelProperty("开发视频审核状态，0-待审核，1-通过，2-不通过")
    @TableField("video_audit_status")
    private Integer videoAuditStatus;

    @ApiModelProperty("开发视频审核备注")
    @TableField("video_audit_remark")
    private String videoAuditRemark;

    @ApiModelProperty("开发视频审核文件url")
    @TableField("video_audit_url")
    private String videoAuditUrl;

    @ApiModelProperty("视频上传后台30天销量")
    @TableField("video_sale_30")
    private Long videoSale30;

    @ApiModelProperty("添加地区")
    @TableField("add_region")
    private String addRegion;

    @ApiModelProperty("视频策划进度，本表中该字段已弃用")
    @TableField("video_plan_progress")
    private Integer videoPlanProgress;

    @ApiModelProperty("摄影视频进度，本表中该字段已弃用")
    @TableField("photo_video_progress")
    private Integer photoVideoProgress;

    @ApiModelProperty("[优化视频]是否需要视频策划,0-否，1-是")
    @TableField("is_video_plan")
    private Integer isVideoPlan;

    @ApiModelProperty("[优化视频]视频优化类型：1-重拍视频，2-产品未拍视频")
    @TableField("video_optimize_type")
    private Integer videoOptimizeType;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("视频是否合格，0-不合格 ，1-合格")
    @TableField("video_is_qualified")
    private Integer videoIsQualified;

    @ApiModelProperty("视频合格备注")
    @TableField("video_qualified_remark")
    private String videoQualifiedRemark;

    @ApiModelProperty("优化类型：0-原始任务(默认)，1-优化任务")
    @TableField("optimize_type")
    private Integer optimizeType;

    @ApiModelProperty("优化备注")
    @TableField("optimize_remark")
    private String optimizeRemark;

    @ApiModelProperty("传达设计表id(visual_communication_design的id)")
    @TableField("communication_design_id")
    private Long communicationDesignId;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("视频开发审核人id")
    @TableField("video_audit_id")
    private Integer videoAuditId;

    @ApiModelProperty("视频开发审核人")
    @TableField("video_audit_name")
    private String videoAuditName;

    @ApiModelProperty("视频开发审核时间")
    @TableField("video_audit_time")
    private Integer videoAuditTime;

    @ApiModelProperty("视频策划编号，本表中该字段已弃用")
    @TableField("video_plan_number")
    private String videoPlanNumber;

    @ApiModelProperty("视频策划，本表中该字段已弃用")
    @TableField("video_plan_name")
    private String videoPlanName;

    @ApiModelProperty("视频策划完成时间，本表中该字段已弃用")
    @TableField("video_plan_finish_time")
    private Integer videoPlanFinishTime;

    @ApiModelProperty("摄影视频编号，本表中该字段已弃用")
    @TableField("photo_video_number")
    private String photoVideoNumber;

    @ApiModelProperty("摄影视频，本表中该字段已弃用")
    @TableField("photo_video_name")
    private String photoVideoName;

    @ApiModelProperty("摄影视频完成时间，本表中该字段已弃用")
    @TableField("photo_video_finish_time")
    private Integer photoVideoFinishTime;

    @ApiModelProperty("视频上传后台时间")
    @TableField("video_upload_backstage_time")
    private Integer videoUploadBackstageTime;

    @ApiModelProperty("视频上传后台人id")
    @TableField("video_upload_backstage_id")
    private Long videoUploadBackstageId;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("相关SKU是否同步,-1-暂无，0-否，1-是")
    @TableField("is_sync")
    private Integer isSync;

    @ApiModelProperty("视频策划ID[visual_video_plan表id]")
    @TableField("video_plan_id")
    private Long videoPlanId;

    @ApiModelProperty("摄影视频ID[visual_photographer表id]")
    @TableField("photographer_id")
    private Long photographerId;

    @ApiModelProperty("视频备注")
    @TableField("video_remark")
    private String videoRemark;

    @ApiModelProperty("剪辑编号，本表中该字段已弃用")
    @TableField("editors_number")
    private String editorsNumber;

    @ApiModelProperty("剪辑师，本表中该字段已弃用")
    @TableField("editors_name")
    private String editorsName;

    @ApiModelProperty("剪辑进度，本表中该字段已弃用")
    @TableField("editor_progress")
    private Integer editorProgress;

    @ApiModelProperty("剪辑完成时间，本表中该字段已弃用")
    @TableField("editor_finish_time")
    private Integer editorFinishTime;

    @ApiModelProperty("创建人类型，0-系统，1-销售，2-策划")
    @TableField("create_type")
    private Integer createType;

    @ApiModelProperty("是否已做优化 0-否 1-是")
    @TableField("is_optimize")
    private Integer isOptimize;

    @ApiModelProperty("商标审核人")
    @TableField("trademark_audit_user")
    private String trademarkAuditUser;

    @ApiModelProperty("商标审核人id")
    @TableField("trademark_audit_user_id")
    private Integer trademarkAuditUserId;

    @ApiModelProperty("商标审核状态 0待审核 1已审核 2商标问题 3拼写问题 4商标+拼写 5无问题")
    @TableField("trademark_audit_status")
    private Integer trademarkAuditStatus;

    @ApiModelProperty("商标审核时间")
    @TableField("trademark_audit_time")
    private Integer trademarkAuditTime;

    @ApiModelProperty("是否周期性产品")
    @TableField("is_period_product")
    private Integer isPeriodProduct;

    @ApiModelProperty("商标审核备注")
    @TableField("trademark_audit_memo")
    private String trademarkAuditMemo;


}
