package cn.kk.spring_simple_operation.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 视觉设计协同系统-摄影A+
 * </p>
 *
 * @author guokunkun
 * @since 2025-02-19
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("visual_photographer_a_plus")
@ApiModel(value = "VisualPhotographerAPlus对象", description = "视觉设计协同系统-摄影A+")
public class VisualPhotographerAPlus implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableId("id")
    private Long id;

    @ApiModelProperty("sku")
    @TableField("sku")
    private String sku;

    @ApiModelProperty("执行者编号")
    @TableField("executor_number")
    private String executorNumber;

    @ApiModelProperty("执行者")
    @TableField("executor_name")
    private String executorName;

    @ApiModelProperty("分配时间")
    @TableField("distribution_time")
    private Integer distributionTime;

    @ApiModelProperty("完成状态，0-未完成，1-进行中，2-完成,3-不需要处理")
    @TableField("`status`")
    private Integer status;

    @ApiModelProperty("完成时间")
    @TableField("finish_time")
    private Integer finishTime;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("创建时间")
    @TableField("create_time")
    private Integer createTime;

    @ApiModelProperty("创建人")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty("创建人id")
    @TableField("create_id")
    private Integer createId;

    @ApiModelProperty("A+表的id")
    @TableField("ap_id")
    private Long apId;

    @ApiModelProperty("visual_a_plus_plan的id")
    @TableField("a_plus_plan_id")
    private Long aPlusPlanId;

    @ApiModelProperty("文件链接")
    @TableField("file_url")
    private String fileUrl;

    @ApiModelProperty("标签id")
    @TableField("vdt_id")
    private Long vdtId;

    @ApiModelProperty("是否删除，0-否，1-是")
    @TableField("is_delete")
    @TableLogic
    private Integer isDelete;

    @ApiModelProperty("设计是否取样，0-否，1-是")
    @TableField("is_take_sample")
    private Integer isTakeSample;

    @ApiModelProperty("取样时间，设计是否取样为是时，需要有值")
    @TableField("take_sample_time")
    private Integer takeSampleTime;

    @ApiModelProperty("取样样品状态::1-正，2-次")
    @TableField("take_sample_status")
    private Integer takeSampleStatus;

    @ApiModelProperty("取样样品备注")
    @TableField("take_sample_status_remark")
    private String takeSampleStatusRemark;


}
