package cn.kk.spring_simple_operation;

import cn.kk.spring_simple_operation.mapper.SyncProductAuditMapper;
import cn.kk.spring_simple_operation.mapper.SyncProductPublishMapper;
import cn.kk.spring_simple_operation.mapper.VideoProductMapper;
import cn.kk.spring_simple_operation.model.PlanSkuInfoVO;
import cn.kk.spring_simple_operation.model.SkuVideoVO;
import cn.kk.spring_simple_operation.utils.ExcelUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@SpringBootTest
class SimpleAPlusTaskExport {

	@Resource
	private SyncProductPublishMapper syncProductPublishMapper;

	@Resource
	private VideoProductMapper videoProductMapper;

	@Resource
	private SyncProductAuditMapper syncProductAuditMapper;


	@Test
	void contextLoads() {
	}

	@Test
	void groupSkuSolarTerm_1() {

		List<String> motherList = syncProductAuditMapper.planSkuForPublish();

		List<String> skuList = new LinkedList<>();
		AtomicInteger count = new AtomicInteger(0);

		motherList.forEach(sku -> {
			if (StringUtils.isEmpty(sku)) {
				return;
			}
			List<SkuVideoVO> skuVideoVOS = syncProductPublishMapper.planSkuForPublishSales(sku);
			if (CollectionUtils.isEmpty(skuVideoVOS)) {
				return;
			}
			Integer sum = skuVideoVOS.stream().map(SkuVideoVO::getThirtyDaySales).reduce(Integer::sum).orElse(0);
			if (sum >= 100 && sum <= 200) {
				//System.out.println(count.incrementAndGet() + "---" + sku + " 销量在100-200之间: " + sum);
				skuList.add(sku);
			}

		});

		if (!CollectionUtils.isEmpty(skuList)) {
			String originName = "简版A+";
			List<PlanSkuInfoVO> list = syncProductAuditMapper.listPlanSkuInfo(skuList);
			ExcelUtil<PlanSkuInfoVO> util = new ExcelUtil<>(PlanSkuInfoVO.class);
			util.exportExcelFile(list, originName);
		}

	}


}
