//package cn.kk.spring_simple_operation;
//
//import cn.kk.spring_simple_operation.entity.SyncProductPublish;
//import cn.kk.spring_simple_operation.mapper.SyncProductPublishMapper;
//import cn.kk.spring_simple_operation.mapper.VideoProductMapper;
//import com.alibaba.fastjson.JSONObject;
//import com.baomidou.mybatisplus.core.toolkit.StringUtils;
//import com.baomidou.mybatisplus.core.toolkit.Wrappers;
//import org.apache.commons.compress.utils.Lists;
//import org.junit.jupiter.api.Test;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.util.CollectionUtils;
//
//import javax.annotation.Resource;
//import java.math.BigDecimal;
//import java.util.*;
//import java.util.stream.Collectors;
//
//@SpringBootTest
//class SpringSimpleOperationApplicationTests {
//
//	private static final BigDecimal               TWENTY = new BigDecimal("20");
//	private static final BigDecimal               FORTY  = new BigDecimal("40");
//	@Resource
//	private              SyncProductPublishMapper syncProductPublishMapper;
//
//	@Resource
//	private VideoProductMapper videoProductMapper;
//
//
//	@Test
//	void contextLoads() {
//	}
//
//	/**
//	 * 1.已开售时间大于1个月 常规产品 无简易和精细化视频产品（正常销售）
//	 * ① 单价<20美金，SKU或变体总月销100+
//	 * ② 单价在20~40美金，SKU或变体总月销80+
//	 * ③单价>40美金，SKU或变体总月销50+
//	 * 2.已开售时间大于1个月 节气产品热卖期在1-6月 无简易和精细化视频产品（正常销售+保留页面）
//	 * ① 单价<20美金，SKU或变体总月销100+
//	 * ② 单价在20~40美金，SKU或变体总月销80+
//	 * ③单价>40美金，SKU或变体总月销50+
//	 */
//	@Test
//	void testSyncProductPublish() {
//		//List<String> shortUrlSkuList = videoProductMapper.selectHaveTask();
//
//		Map<String, Integer> salesMap = new HashMap<>();
//		salesMap.put("0~20", 0);
//		salesMap.put("20~40", 0);
//		salesMap.put(">40", 0);
//
//		Set<String> haveSkuSet = new HashSet<>();
//
//		// 母体sku
//		List<SyncProductPublish> syncProductPublishes = syncProductPublishMapper.selectMotherSku();
//		List<SyncProductPublish> syncProductPublishes_2 = new LinkedList<>();
//
//		syncProductPublishes.forEach(item -> {
//			List<SyncProductPublish> subList = syncProductPublishMapper.selectList(Wrappers.<SyncProductPublish>lambdaQuery().eq(SyncProductPublish::getParentAsin, item.getRelationKey()).select(SyncProductPublish::getSku, SyncProductPublish::getThirtyDaySales));
//			subList.add(item);
//
//			String s = checkPriceAndSales(subList, item.getLowestPrice());
//			if (StringUtils.isBlank(s)) {
//				return;
//			}
//			salesMap.put(s, salesMap.get(s) + 1);
//			haveSkuSet.addAll(subList.stream().map(SyncProductPublish::getSku).collect(Collectors.toList()));
//			syncProductPublishes_2.addAll(subList);
//		});
//		//System.out.println(JSONObject.toJSONString(salesMap));
//		printSkuList(syncProductPublishes_2);
//		printMap(salesMap);
//
//		try {
//			Thread.sleep(1000);
//		} catch (InterruptedException e) {
//			e.printStackTrace();
//		}
//
//		Map<String, Integer> salesMap_2 = new HashMap<>();
//		salesMap_2.put("0~20", 0);
//		salesMap_2.put("20~40", 0);
//		salesMap_2.put(">40", 0);
//
//		List<SyncProductPublish> publishList = syncProductPublishMapper.selectChildSku();
//		List<SyncProductPublish> publishList_2 = new LinkedList<>();
//
//		publishList.forEach(item -> {
//			if (haveSkuSet.contains(item.getSku())) {
//				return;
//			}
//			ArrayList<SyncProductPublish> list = new ArrayList<>();
//			list.add(item);
//			String s = checkPriceAndSales(list, item.getLowestPrice());
//			if (StringUtils.isBlank(s)) {
//				return;
//			}
//			salesMap_2.put(s, salesMap_2.get(s) + 1);
//			publishList_2.add(item);
//		});
//		//System.out.println(JSONObject.toJSONString(salesMap_2));
//		printSkuList(publishList_2);
//		printMap(salesMap_2);
//	}
//
//	private String checkPriceAndSales(List<SyncProductPublish> subList, BigDecimal lowestPrice) {
//		if (CollectionUtils.isEmpty(subList) || lowestPrice.compareTo(BigDecimal.ZERO) < 0) {
//			return null;
//		}
//		int sum = subList.stream().map(SyncProductPublish::getThirtyDaySales).reduce(Integer::sum).get();
//		if (lowestPrice.compareTo(TWENTY) <= 0 && sum >= 100) {
//			return "0~20";
//		}
//		else if (lowestPrice.compareTo(TWENTY) > 0 && lowestPrice.compareTo(FORTY) <= 0 && sum >= 80) {
//			return "20~40";
//		}
//		else if (lowestPrice.compareTo(FORTY) > 0 && sum >= 50) {
//			return ">40";
//		}
//		return null;
//	}
//
//	private void printSkuList(List<SyncProductPublish> list) {
//		list.forEach(item -> {
//			String content = String.format("sku: %s, 30天销量: %d, price: %s, relationKey: %s, parentAsin: %s", item.getSku(), item.getThirtyDaySales(), item.getLowestPrice(), item.getRelationKey(), item.getParentAsin());
//			System.out.println(content);
//		});
//	}
//
//	private void printMap(Map<String, Integer> salesMap) {
//		System.out.println("0~20: " + salesMap.get("0~20"));
//		System.out.println("20~40: " + salesMap.get("20~40"));
//		System.out.println(">40: " + salesMap.get(">40"));
//	}
//
//	@Test
//	void testSyncProductPublish_2() {
//		//List<String> shortUrlSkuList = videoProductMapper.selectHaveTask();
//
//		Map<String, Integer> salesMap = new HashMap<>();
//		salesMap.put("0~20", 0);
//		salesMap.put("20~40", 0);
//		salesMap.put(">40", 0);
//
//		Set<String> haveSkuSet = new HashSet<>();
//
//		// 母体sku
//		List<SyncProductPublish> syncProductPublishes = syncProductPublishMapper.selectMotherSku_2();
//		List<SyncProductPublish> syncProductPublishes_2 = new LinkedList<>();
//
//		syncProductPublishes.forEach(item -> {
//			List<SyncProductPublish> subList = syncProductPublishMapper.selectList(Wrappers.<SyncProductPublish>lambdaQuery().eq(SyncProductPublish::getParentAsin, item.getRelationKey()).select(SyncProductPublish::getSku, SyncProductPublish::getThirtyDaySales));
//			subList.add(item);
//
//			String s = checkPriceAndSales(subList, item.getLowestPrice());
//			if (StringUtils.isBlank(s)) {
//				return;
//			}
//			salesMap.put(s, salesMap.get(s) + 1);
//			haveSkuSet.addAll(subList.stream().map(SyncProductPublish::getSku).collect(Collectors.toList()));
//			syncProductPublishes_2.addAll(subList);
//		});
//		//System.out.println(JSONObject.toJSONString(salesMap));
//		printSkuList(syncProductPublishes_2);
//		printMap(salesMap);
//
//		try {
//			Thread.sleep(1000);
//		} catch (InterruptedException e) {
//			e.printStackTrace();
//		}
//
//		Map<String, Integer> salesMap_2 = new HashMap<>();
//		salesMap_2.put("0~20", 0);
//		salesMap_2.put("20~40", 0);
//		salesMap_2.put(">40", 0);
//
//		List<SyncProductPublish> publishList = syncProductPublishMapper.selectChildSku_2();
//		List<SyncProductPublish> publishList_2 = new LinkedList<>();
//
//		publishList.forEach(item -> {
//			if (haveSkuSet.contains(item.getSku())) {
//				return;
//			}
//			ArrayList<SyncProductPublish> list = new ArrayList<>();
//			list.add(item);
//			String s = checkPriceAndSales(list, item.getLowestPrice());
//			if (StringUtils.isBlank(s)) {
//				return;
//			}
//			salesMap_2.put(s, salesMap_2.get(s) + 1);
//			publishList_2.add(item);
//		});
//		//System.out.println(JSONObject.toJSONString(salesMap_2));
//		printSkuList(publishList_2);
//		printMap(salesMap_2);
//	}
//
//}
