import time
import random
import logging
import sys, os
import pandas as pd
from func_timeout import func_set_timeout
sys.path.append(os.path.dirname(os.path.dirname(sys.path[0])))  # 上级目录
from amazon_spider.conf.db import selection_table_name
from amazon_spider.db.mysql_db import get_country_engine
from amazon_spider.db.pg_db import get_pg_country_engine


class ReadDb(object):
    def __init__(self, site="us"):
        self.site_name = site
        self.db_syn = selection_table_name.get(f"{self.site_name}_asin_table")
        self.db_comment_num_table = selection_table_name.get(f"{self.site_name}_comment_num_table")
        self.read_size = "30"
        self.df_read = pd.DataFrame()
        self.index_tuple = tuple()
        while True:
            if self.is_internet_available():
                self.engine_mysql = get_country_engine(self.site_name)
                logging.info("网络链接成功")
                break
            else:
                logging.info("网络断开  等待3秒")
                time.sleep(3)
                continue
        while True:
            if self.is_internet_available():
                self.engine_pg6 = get_pg_country_engine(self.site_name)
                logging.info("网络链接成功")
                break
            else:
                logging.info("网络断开  等待3秒")
                time.sleep(3)
                continue


    def is_internet_available(self):
        import requests
        try:
            requests.get("http://www.baidu.com", timeout=1)
            return True
        except:
            return False

    @func_set_timeout(30)
    def read_db_data(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT distinct(asin) FROM {self.db_syn} WHERE STATE=1;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.db_syn} a set state=2 where a.asin in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE {self.db_syn} a set state=2 where a.asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    # @func_set_timeout(30)
    def read_db_self_asin_temporary(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT distinct(asin) FROM {self.site_name}_self_asin;'
                    # sql_read = f'SELECT distinct(asin) FROM {self.site}_self_asin;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(200)
    def read_self_asin_seeds(self):
        sql1 = f"select asin from {self.site_name}_self_asin_spider where state in (1, 2);"
        df_asin = pd.read_sql(sql1, con=self.engine_mysql)
        # sql2 = f"select asin from {self.site_name}_self_real_spider where site='{self.site_name}';"
        # df_real_asin = pd.read_sql(sql2, con=self.engine_mysql)
        # df_asin = df_self_asin[~df_self_asin['asin'].isin(df_real_asin["asin"])]
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    df_asin.drop_duplicates(['asin'], inplace=True)
                    if df_asin.shape[0] > 0:
                        self.index_tuple = tuple(df_asin['asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE `{self.site_name}_self_asin_spider` a set state=2 where a.asin in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE `{self.site_name}_self_asin_spider` a set state=2 where a.asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return df_asin
                    else:
                        return pd.DataFrame([], columns=['asin'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue
        return df_asin

    @func_set_timeout(180)
    def read_db_variat(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = 'SELECT parent_asin, comment_new_time FROM `%s_self_variat` GROUP BY parent_asin for update;' % (self.site_name)
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['parent_asin', 'comment_new_time'])
                    self.df_read.drop_duplicates(['parent_asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['parent_asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE `{self.site_name}_self_variat` a set state=2 where a.parent_asin in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE `{self.site_name}_self_variat` a set state=2 where a.parent_asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['parent_asin', 'comment_new_time'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(100)
    def get_seeds(self):
        sql = f"select id, parent_asin as asin from {self.site_name}_self_variat where state=1;"
        df_self_asin = pd.read_sql(sql, con=self.engine_mysql)

        sql = f"SELECT parent_asin as asin, comment_num from {self.db_comment_num_table};"
        df_asin_comment_num = pd.read_sql(sql, con=self.engine_mysql)

        df_check_num = df_self_asin.merge(df_asin_comment_num, on='asin', how='left')

        df_check_num = df_check_num.fillna(0)

        return df_check_num

    @func_set_timeout(10)
    def get_asin_seeds(self):
        sql = f"select bsrlink from category_bsr_data_templete;"
        df_self_asin = pd.read_sql(sql, con=self.engine_mysql)
        return df_self_asin

    @func_set_timeout(10)
    def read_db_detail(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin, id, `is_variat`, `week`, `data_type` FROM {self.site_name}_all_syn_st WHERE STATE=1 LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'is_variat', 'week', 'data_type'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_all_syn_st a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_all_syn_st a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'is_variat', 'week', 'data_type'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(30)
    def read_db_mx_asin(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    # sql_read = f'-- SELECT asin, id, site FROM mx_self_asin WHERE site="Amazon.nl" LIMIT 1 for update;'

                    sql_read = f'SELECT asin, id, site FROM mx_self_asin WHERE STATE=1 and site in ("Amazon.com.mx", "Amazon.nl", "Amazon.com.be") LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'site'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE mx_self_asin a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE mx_self_asin a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'site'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(10)
    def read_db_feedback(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f"SELECT `id`, `account_name`, `url` FROM {self.site_name}_seller_account_syn where state=1 LIMIT 30 for update;;"
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'account_name', 'url'])
                    self.df_read.drop_duplicates(['account_name'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_seller_account_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_seller_account_syn a set state=2 where a.id in {self.index_tuple}"""
                        print(sql_update)
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'account_name', 'url'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    # @func_set_timeout(30)
    def read_db_keepa(self):
        while True:
            try:
                # SELECT * from us_self_all_syn WHERE state=3 and updated_at>="2023-11-08" limit 10000;
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site, priority FROM {self.site_name}_self_all_syn WHERE STATE=1 ORDER BY priority asc;'
                    # sql_read = 'SELECT asin,id,data_type,is_variation, date_info, site from us_self_all_syn WHERE state=1 and updated_at>="2023-11-08" limit 10000;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'priority'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'priority'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    def read_db_tautology_keepa(self):
        while True:
            try:
                # SELECT * from us_self_all_syn WHERE state=3 and updated_at>="2023-11-08" limit 10000;
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site, priority FROM {self.site_name}_self_all_syn WHERE (TIMESTAMPDIFF(MINUTE, updated_at, NOW()) > 60) and state in (1, 2) and data_type like "%%3%%";'
                    # sql_read = 'SELECT asin,id,data_type,is_variation, date_info, site from us_self_all_syn WHERE state=1 and updated_at>="2023-11-08" limit 10000;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'priority'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_all_syn a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'priority'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(30)
    def read_db_real_keepa(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site, account_id, priority FROM {self.site_name}_self_real_spider WHERE site="ca" and state in (1,2) order by priority, updated_at asc;'
                    a = conn.execute(sql_read)
                    logging.info(f"sql_read执行成功{sql_read}")
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id', 'priority'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        logging.info(f"sql_update执行成功{sql_update}")
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id', 'priority'])
            except Exception as e:
                logging.info(f"读取数据出bug并等待5s继续{e}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(30)
    def read_db_real_collect_keepa(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin,id,data_type,is_variation, date_info, site, account_id, priority FROM {self.site_name}_self_real_spider WHERE (end_time >""  and state=1) or ((TIMESTAMPDIFF(MINUTE, updated_at, NOW()) > 60) and end_time >"" and state=2);'
                    a = conn.execute(sql_read)
                    logging.info(f"sql_read执行成功{sql_read}")
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id', 'priority'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2,updated_at = NOW() where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2,updated_at = NOW() where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        logging.info(f"sql_update执行成功{sql_update}")
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'data_type', 'is_variation', 'date_info', 'site', 'account_id', 'priority'])
            except Exception as e:
                logging.info(f"读取数据出bug并等待5s继续{e}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(10)
    def read_db_temu_serch_keyword(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, new_title as search_term, asin, site from us_self_asin_top where state=1 limit 10 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'search_term', 'asin', 'site'])
                self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'search_term', 'asin', 'site'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)
            # continue

    @func_set_timeout(20)
    def read_db_temu_bsr(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, opt_name, opt_type, opt_id from temu_bsr_cate where state=1 limit 1 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'opt_name', 'opt_type', 'opt_id'])
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE temu_bsr_cate a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE temu_bsr_cate a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'opt_name', 'opt_type', 'opt_id'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)
            # continue

    @func_set_timeout(10)
    def read_db_1688_serch_keyword(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, search_term from 1688_search_term where state=1 limit 25 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'search_term'])
                self.df_read.drop_duplicates(['search_term'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE 1688_search_term a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE 1688_search_term a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'search_term'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)
            # continue

    @func_set_timeout(10)
    def read_db_1688_detail(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, memberId, company_name, search_term from 1688_company_id where state=1 limit 25 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'memberId', 'company_name', 'search_term'])
                self.df_read.drop_duplicates(['memberId'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE 1688_company_id a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE 1688_company_id a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'memberId', 'company_name', 'search_term'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)
            # continue

    @func_set_timeout(10)
    def read_db_1688_address(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, factory_name from 1688_factory_name where state=1 limit 25 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'factory_name'])
                self.df_read.drop_duplicates(['factory_name'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE 1688_factory_name a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE 1688_factory_name a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'factory_name'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)
            # continue

    @func_set_timeout(10)
    def read_db_1688_contact_info(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, memberId, company_name, search_term from 1688_company_id where state=3 limit 25 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'memberId', 'company_name', 'search_term'])
                self.df_read.drop_duplicates(['memberId'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE 1688_company_id a set state=4 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE 1688_company_id a set state=4 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'memberId', 'company_name', 'search_term'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)

    @func_set_timeout(10)
    def read_db_1688_memberId(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, memberId from company_info_1688 where state=1 limit 1 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'memberId'])
                self.df_read.drop_duplicates(['memberId'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE company_info_1688 a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE company_info_1688 a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'memberId'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)

    @func_set_timeout(10)
    def read_db_temu_search_keyword(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, search_term from temu_search_term where state=1 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'search_term'])
                self.df_read.drop_duplicates(['search_term'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE temu_search_term a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE temu_search_term a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'search_term'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)

    @func_set_timeout(10)
    def read_db_temu_detail(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, goodid from temu_good_id_copy1 where state=1 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'goodid'])
                self.df_read.drop_duplicates(['goodid'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE temu_good_id a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE temu_good_id a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'goodid'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)


    @func_set_timeout(30)
    def read_db_upc_asin(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin,id FROM upc_asin WHERE STATE=1 LIMIT 30 for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id'])
                    self.df_read.drop_duplicates(['asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE upc_asin a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE upc_asin a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(10)
    def read_db_temu_img_search_keyword(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, asin, old_title, site from us_self_asin_top where state=1 and site="us" for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'old_title', 'site'])
                self.df_read.drop_duplicates(['asin', 'old_title'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE us_self_asin_top a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'asin', 'old_title', 'site'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)

    @func_set_timeout(10)
    def read_db_top_asin(self):
        try:
            with self.engine_mysql.begin() as conn:
                sql_read = f'SELECT id, asin, site from us_self_asin_top_hz where state=1 and site="us" limit 30 for update;'
                a = conn.execute(sql_read)
                self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'site'])
                self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                if self.df_read.shape[0] > 0:
                    self.index_tuple = tuple(self.df_read['id'])
                    if len(self.index_tuple) == 1:
                        sql_update = f"""UPDATE us_self_asin_top_hz a set state=2 where a.id in ({self.index_tuple[0]})"""
                    else:
                        sql_update = f"""UPDATE us_self_asin_top_hz a set state=2 where a.id in {self.index_tuple}"""
                    conn.execute(sql_update)
                    return self.df_read
                else:
                    return pd.DataFrame([], columns=['id', 'asin', 'site'])
        except Exception as e:
            # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
            time.sleep(random.uniform(3, 10.5))
            self.engine_mysql = get_country_engine(self.site_name)

    @func_set_timeout(30)
    def read_db_video_asin(self, site):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT asin, id, site, sku FROM asin_video_spider WHERE STATE=1 and site="{site}";'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'site', 'sku'])
                    self.df_read.drop_duplicates(['asin', 'sku', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE asin_video_spider a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE asin_video_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'site', 'sku'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(30)
    def read_db_video_bsr_cate_asin(self, site):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'''SELECT asin, id, site, rank, bsr_url FROM asin_bsr__video_url WHERE STATE=1 and site="{site}" and bsr_url is not null and bsr_url in ('/gp/bestsellers/kitchen/3737281/ref=pd_zg_hrsr_kitchen',
                    '/gp/bestsellers/hi/552594/ref=pd_zg_hrsr_hi',
                    '/gp/bestsellers/fashion/9056963011/ref=pd_zg_hrsr_fashion',
                    '/gp/bestsellers/hpc/14442631/ref=pd_zg_hrsr_hpc',
                    '/gp/bestsellers/fashion/9057019011/ref=pd_zg_hrsr_fashion');'''
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'site', 'rank', 'bsr_url'])
                    self.df_read.drop_duplicates(['asin', 'bsr_url', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE asin_bsr__video_url a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE asin_bsr__video_url a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'site', 'rank', 'bsr_url'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue


    @func_set_timeout(30)
    def read_db_asin_video_bsr_spider(self, site):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    # """SELECT source_asin, asin, bsr_url from asin_video_bsr_spider where created_at>='2024-03-05 13:00:00'"""
                    sql_read = f'SELECT asin, id, site, source_asin, bsr_url FROM asin_video_bsr_spider WHERE STATE=1 and site="{site}" for update;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['asin', 'id', 'site', 'source_asin', 'bsr_url'])
                    self.df_read.drop_duplicates(['asin', 'site', 'source_asin', 'bsr_url'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE asin_video_bsr_spider a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE asin_video_bsr_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['asin', 'id', 'site', 'source_asin', 'bsr_url'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    def read_seller(self):
        sql_seller = f"select asin, site,  GROUP_CONCAT(seller_id SEPARATOR '|-|') as other_sellers_id, GROUP_CONCAT(seller_name SEPARATOR '|-|') as other_seller_name,  GROUP_CONCAT(buy_boy_type SEPARATOR '|-|') as other_seller_buy_boy_type from self_asin_seller_old where created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR) GROUP BY asin, site;"
        df_seller = pd.read_sql(sql_seller, con=get_country_engine("us"))
        df_seller.drop_duplicates(subset=["asin", "site"], inplace=True)
        # sql_real = f"SELECT asin, site, data_type, is_variation, date_info, site, account_id, priority from {self.site_name}_self_real_spider WHERE state=1;"
        sql_real = f"SELECT id, asin, site, data_type, is_variation, date_info, account_id, priority, updated_at from {self.site_name}_self_real_spider WHERE state=1;"
        df_real = pd.read_sql(sql_real, con=self.engine_mysql)
        df_real.drop_duplicates(subset=["asin", "site"], inplace=True)
        df_check_num = df_real.merge(df_seller, on=['asin', 'site'], how='left')
        return df_check_num

    def read_db_seller_asin(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    self.df_read = self.read_seller()
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_real_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_mysql.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=[
                            'asin', 'id', 'site', 'data_type', 'is_variation', 'date_info', 'account_id',
                            'priority', 'updated_at', 'other_sellers_id', 'other_seller_name',
                            'other_seller_buy_boy_type'
                        ])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql.dispose()
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    @func_set_timeout(180)
    def comment_svg(self):
        sql1 = f"SELECT parent_asin, star, count(parent_asin) as spider_num from {self.site_name}_asin_comment where star is not null GROUP BY parent_asin, star;"
        comment = pd.read_sql(sql1, con=self.engine_mysql)

        sql2 = f"SELECT parent_asin, comment_num, star from {self.site_name}_asin_comment_num where star is not null;"
        comment_num = pd.read_sql(sql2, con=self.engine_mysql)

        sql3 = f"""SELECT t1.parent_asin as parent_asin FROM {self.site_name}_asin_comment t1
        LEFT JOIN {self.site_name}_asin_comment_num t2 ON t1.parent_asin = t2.parent_asin where t1.star is not null and t2.star is not null and t2.comment_num!=0
        GROUP BY t1.parent_asin HAVING count(distinct t2.star)!=count(distinct t1.star)  limit 10000
        ;"""
        comment_star_num = pd.read_sql(sql3, con=self.engine_mysql)

        comm = pd.merge(comment, comment_num,
                        how='inner',  # 内合并代表两对象交集
                        on=['parent_asin', 'star']  # 两个表的关联建，即相同便可以关联上，不同数据就关联不上
                        )
        error = comm[(comm['spider_num']!=comm['comment_num']) & (comm['spider_num']<100) & (comm['spider_num']<comm['comment_num']) & ((comm["comment_num"] - comm["spider_num"] >= 5) & (comm['comment_num']<100))]
        datas = error.append(comment_star_num)
        # comm = df_check_num.fillna(0)
        return datas

    # @func_set_timeout(180)
    def asin_comment_seeds(self):
        while True:
            try:
                with self.engine_pg6.begin() as conn:
                    sql_read = f"select distinct parent_asin from {self.site_name}_asin_spider_comment where state=3 and parent_asin>'' limit 20000;"

                    a = conn.execute(sql_read)
                    logging.info("数据读取source")
                    self.df_read = pd.DataFrame(a, columns=['parent_asin'])
                    self.df_read.drop_duplicates(['parent_asin'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['parent_asin'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_asin_spider_comment a set state=4 where a.parent_asin in ({self.index_tuple[0]})"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_asin_spider_comment a set state=4 where a.parent_asin in {self.index_tuple}"""
                        conn.execute(sql_update)
                        self.engine_pg6.dispose()
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['parent_asin'])
            except Exception as e:
                print("读取数据出bug并等待5s继续", e)
                time.sleep(random.uniform(3, 10.5))
                self.engine_pg6.dispose()
                self.engine_pg6 = get_pg_country_engine(self.site_name)
                continue

    # @func_set_timeout(180)
    def read_db_self_return(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT id, asin, site FROM {self.site_name}_self_asin_returns_new WHERE STATE=1;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'site'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_asin_returns_new a set state=2 where a.id in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_asin_returns_new a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'asin', 'site'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue


    # @func_set_timeout(30)
    def read_db_self_other(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT id, asin, site FROM other_self_asin WHERE site!="jp" and data_type not like "%%7%%";'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'site'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE other_self_asin a set state=2 where a.id in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE other_self_asin a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'asin', 'site'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    def read_db_self_search_results(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT id, asin, username, sku, site FROM {self.site_name}_self_asin_search_results WHERE state="1";'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'username', 'sku', 'site'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE {self.site_name}_self_asin_search_results a set state=2 where a.id in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE {self.site_name}_self_asin_search_results a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'asin', 'username', 'sku', 'site'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue

    def read_db_other_search_asin_spider(self):
        while True:
            try:
                with self.engine_mysql.begin() as conn:
                    sql_read = f'SELECT id, asin, sku, site FROM other_search_asin_spider WHERE state in (1, 2) and results is null;'
                    a = conn.execute(sql_read)
                    self.df_read = pd.DataFrame(a, columns=['id', 'asin', 'sku', 'site'])
                    self.df_read.drop_duplicates(['asin', 'site'], inplace=True)
                    if self.df_read.shape[0] > 0:
                        self.index_tuple = tuple(self.df_read['id'])
                        if len(self.index_tuple) == 1:
                            sql_update = f"""UPDATE other_search_asin_spider a set state=2 where a.id in ('{self.index_tuple[0]}')"""
                        else:
                            sql_update = f"""UPDATE other_search_asin_spider a set state=2 where a.id in {self.index_tuple}"""
                        conn.execute(sql_update)
                        return self.df_read
                    else:
                        return pd.DataFrame([], columns=['id', 'asin', 'sku', 'site'])
            except Exception as e:
                # print("读取数据出bug并等待5s继续", e, f"\n{traceback.format_exc()}")
                time.sleep(random.uniform(3, 10.5))
                self.engine_mysql = get_country_engine(self.site_name)
                continue


class ReadCookie(object):
    def __init__(self, site="us"):
        self.site_name = site
        self.db_syn = selection_table_name.get(f"{self.site_name}_comment_cookies_table")
        self.df_read = pd.DataFrame()
        self.index_tuple = tuple()
        self.engine = get_country_engine(self.site_name)
        # self.conn = self.engine_mysql.connect()

    @func_set_timeout(80)
    def get_cookie(self):
        # c = int(time.time()) - 345600
        c = int(time.time()) - (86400 * 6)
        if self.site_name not in ['us', 'uk', 'fr', 'es', 'it', 'de']:
            self.db_syn = "other_site_cookies"
        t = time.strftime("%Y-%m-%d", time.gmtime(c))
        # if self.site_name == "us":
        #     # sql = f'select cookies,id from {self.site_name}_cookies limit 10;'
        #     sql = f'select cookies from {self.site_name}_cookies where created_time>"{t}";'
        # else:
        if self.site_name in ['us', 'uk', 'fr', 'es', 'it', 'de']:
            sql = f'select cookies from {self.db_syn} where created_time>"{t}"'
        else:
            sql = f'select cookies, site from {self.db_syn} where created_time>"{t}"'
                # sql = f"""
                #     SET @row_number := 0;
                #     SET @site := '';
                #     SELECT cookies, site
                #     FROM (
                #         SELECT
                #             *,
                #             @row_number := IF(@site = site, @row_number + 1, 1) AS row_num,
                #             @site := site
                #         FROM {self.db_syn} where created_time>="{t}" ORDER BY site, created_time
                #     ) AS temp_table
                #     WHERE row_num <= 20000;"""
        # sql = f'select cookies,id from {self.db_syn} where state=1 and created_time>"{t}"'
        df_cookie = pd.read_sql(sql, con=self.engine)
        return df_cookie

    @func_set_timeout(30)
    def get_amazon_temu_not_likes(self):
        sql1 = "SELECT text from amazon_temu_not_likes;"
        df_not_like = pd.read_sql(sql1, con=self.engine)
        return df_not_like


# class ReadKeepa(object):
#     def __init__(self, site="us"):
#         # self.site_name = site
#         # self.db_syn = selection_table_name.get(f"{self.site_name}_comment_cookies_table")
#         self.df_read = pd.DataFrame()
#         self.index_tuple = tuple()
#         self.engine_mysql = get_country_engine("keepa")
#         self.conn = self.engine_mysql.connect()
#
#     def get_keepa_seeds(self):
#
#         sql = f"select asin from `product_publish` where `sales_90` > 0 and `salesChannel` = 'Amazon.com' and  (sale_status in ('正常销售', '精品打造阶段', '精品维护阶段', '发货限制安排跟卖', '已安排跟卖') or (sale_status = '清仓下架' and fulFillable > 1)) and asin not in (SELECT asin from  product_publish_keepa);"
#         # sql = f'-- select cookies,id from it_cookies where created_time>"{t}"'
#         df_seeds = pd.read_sql(sql, con=self.conn)
#
#         sql_keepa = f"SELECT * from  product_publish_keepa"
#         df_keepa = pd.read_sql(sql, con=self.conn)
#         return df_seeds

# star_time = time.time()
# print(len(list(ReadCookie("other").get_cookie().values)))
# print(time.time() - star_time)
# df = ReadDb("us").read_db_real_collect_keepa()
# print(df)

# ReadKeepa("fr").get_keepa_seeds()


