import json

from utils.datahub_util import build_column_lineages

to_tb = "dim_brand_info"
sources = [
    {
        "form": "dim_st_detail",
        "mappings": [
            ("search_term", "search_term"),
        ]
    },
    {
        "form": "dwd_st_asin_measure",
        "mappings": [
            ("search_term", "search_term"),
        ]
    },
    {
        "form": "dim_asin_detail",
        "mappings": [
            ("asin_brand_name", "asin_brand_name"),
        ]
    }
]

if __name__ == '__main__':
    config = []
    for source in sources:
        for mapping in source["mappings"]:
            config.append(
                {
                    "from": f"{source['form']}.{mapping[0]}",
                    "to": f"{to_tb}.{mapping[1]}",
                },
            )
            pass

    url = build_column_lineages(config)
    print(url)
    pass

pass
