import pandas as pd
import sys, os
import logging
import time
sys.path.append(os.path.dirname(sys.path[0]))
from db.mysql_db import get_country_engine, sql_insert, sql_insert_many, sql_connect, sql_delete, sql_update_many

logging.basicConfig(format='%(asctime)s %(name)s %(levelname)s %(message)s',
                    level=logging.INFO)

engine = get_country_engine('us')


def get_all_syn():
    sql = 'SELECT asin from us_self_all_syn WHERE data_type like "%%11%%";'
    df_syn_asin = pd.read_sql(sql, con=engine)
    return df_syn_asin


def get_detail():
    sql = 'SELECT asin from us_self_asin_detail where asin_type like "%%11%%";'
    df_syn_asin = pd.read_sql(sql, con=engine)
    return df_syn_asin


all_syn = get_all_syn()

detail = get_detail()

up_a = all_syn[~all_syn['asin'].isin(detail["asin"])]
print(up_a)

up_asin = [list(i) for i in up_a.values]

sql_up = f"UPDATE `us_self_asin_detail` set asin_type=concat(asin_type, ',11')  where asin=(%s) and created_at>='2023-06-01';"
sql_connect("us")
sql_update_many(sql_up, up_asin)





