import os
import sys

sys.path.append(os.path.dirname(sys.path[0]))
from utils.ssh_util import SSHUtil
from utils.common_util import CommonUtil,DateTypes
from utils.hdfs_utils import HdfsUtils

if __name__ == '__main__':
    site_name = CommonUtil.get_sys_arg(1, None)
    date_type = CommonUtil.get_sys_arg(2, None)
    date_info = CommonUtil.get_sys_arg(3, None)
    assert site_name is not None, "site_name 不能为空！"
    assert date_type is not None, "date_type 不能为空！"
    assert date_info is not None, "date_info 不能为空！"
    year, week = date_info.split("-")
    hive_tb = "ods_bs_category_asin_detail"
    partition_dict = {
        "site_name": site_name,
        "date_type": date_type,
        "date_info": date_info,
    }
    hdfs_path = CommonUtil.build_hdfs_path(hive_tb, partition_dict=partition_dict)
    print(f"hdfs_path is {hdfs_path}")

    if date_type == DateTypes.week.name:
        if site_name == "us":
            if date_info >= '2023-18':
                db_type = "postgresql"
                if date_info >= '2023-34':
                    db_type = 'postgresql_14'
                import_tb = f"{site_name}_bs_category_asin_detail_{year}_{week}"
                cols = f"id,asin,{week} as week,best_sellers_rank,created_time as created_at,updated_time as updated_at,last_herf,all_best_sellers_href"
                params = "1 = 1"

            else:
                db_type = "mysql"
                import_tb = f"{site_name}_bs_category_asin_detail"
                cols = "id,asin,week,best_sellers_rank,created_at,updated_at,last_herf"
                params = f"week = {int(week)} and DATE_FORMAT(created_at,'%Y') = {year}"
        else:
            db_type = "postgresql_14"
            import_tb = f"{site_name}_bs_category_asin_detail_{year}_{week}"
            cols = f"id,asin,{week} as week,best_sellers_rank,created_time as created_at,updated_time as updated_at,last_herf,all_best_sellers_href"
            params = "1 = 1"

    if date_type == DateTypes.month.name or date_type == DateTypes.month_week.name:
        # 日期拆分
        d1, d2 = CommonUtil.split_month_week_date(date_type, date_info)
        if site_name in ['us', 'uk', 'de']:
            db_type = 'postgresql_14'
            # pg的分区单位数是带0，如01、02、03
            d2 = f'0{d2}' if int(d2) < 10 else f'{d2}'
            cols = f"id,asin,null as week,best_sellers_rank,created_time as created_at,updated_time as updated_at,last_herf,all_best_sellers_href"
            import_tb = f"{site_name}_bs_category_asin_detail_month_{d1}_{d2}"
            params = f" 1=1 "
        else:
            print(f"其他站点{date_type}数据暂未明确，请检查是否dateType传输有误")
            exit()

    query = f"""
       select 
       {cols}
        from {import_tb}
        where {params}
        and \$CONDITIONS
    """

    empty_flag, check_flag = CommonUtil.check_schema_before_import(db_type=db_type,
                                                                   site_name=site_name,
                                                                   query=query,
                                                                   hive_tb_name=hive_tb,
                                                                   msg_usr=['wangrui4']
                                                                   )
    assert check_flag, f"导入hive表{hive_tb}表结构检查失败！请检查query是否异常！！"

    if not empty_flag:
        sh = CommonUtil.build_import_sh(site_name=site_name,
                                        db_type=db_type,
                                        query=query,
                                        hdfs_path=hdfs_path)
        # 导入前先删除
        HdfsUtils.delete_hdfs_file(hdfs_path)
        client = SSHUtil.get_ssh_client()
        SSHUtil.exec_command_async(client, sh, ignore_err=False)
        CommonUtil.after_import(hdfs_path=hdfs_path, hive_tb=hive_tb)
        client.close()

        # 导入后检测--检测数据一致性
        CommonUtil.check_import_sync_num(db_type=db_type,
                                         partition_dict=partition_dict,
                                         import_query=query,
                                         hive_tb_name=hive_tb,
                                         msg_usr=['wangrui4']
                                         )

    pass
